/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi.annotation;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.painless.spi.annotation.InjectConstantAnnotation;
import org.elasticsearch.painless.spi.annotation.WhitelistAnnotationParser;

public class InjectConstantAnnotationParser
implements WhitelistAnnotationParser {
    public static final InjectConstantAnnotationParser INSTANCE = new InjectConstantAnnotationParser();

    private InjectConstantAnnotationParser() {
    }

    @Override
    public Object parse(Map<String, String> arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("[@inject_constant] requires at least one name to inject");
        }
        ArrayList<String> argList = new ArrayList<String>(arguments.size());
        for (int i = 1; i <= arguments.size(); ++i) {
            String argNum = Integer.toString(i);
            if (!arguments.containsKey(argNum)) {
                throw new IllegalArgumentException("[@inject_constant] missing argument number [" + argNum + "]");
            }
            argList.add(arguments.get(argNum));
        }
        return new InjectConstantAnnotation(argList);
    }
}

