/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.logsdb.LogsDBInfoTransportAction;
import org.elasticsearch.xpack.logsdb.LogsDBUsageTransportAction;
import org.elasticsearch.xpack.logsdb.LogsPatternUsageService;
import org.elasticsearch.xpack.logsdb.LogsdbIndexModeSettingsProvider;
import org.elasticsearch.xpack.logsdb.LogsdbLicenseService;

public class LogsDBPlugin
extends Plugin
implements ActionPlugin {
    private final Settings settings;
    private final LogsdbLicenseService licenseService;
    public static final Setting<Boolean> CLUSTER_LOGSDB_ENABLED = Setting.boolSetting((String)"cluster.logsdb.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final LogsdbIndexModeSettingsProvider logsdbIndexModeSettingsProvider;

    public LogsDBPlugin(Settings settings) {
        this.settings = settings;
        this.licenseService = new LogsdbLicenseService(settings);
        this.logsdbIndexModeSettingsProvider = new LogsdbIndexModeSettingsProvider(this.licenseService, settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.licenseService.setLicenseService(this.getLicenseService());
        this.licenseService.setLicenseState(this.getLicenseState());
        ClusterSettings clusterSettings = services.clusterService().getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(LogsdbLicenseService.FALLBACK_SETTING, this.licenseService::setSyntheticSourceFallback);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_LOGSDB_ENABLED, this.logsdbIndexModeSettingsProvider::updateClusterIndexModeLogsdbEnabled);
        ClusterService clusterService = services.clusterService();
        Supplier<Metadata> metadataSupplier = () -> clusterService.state().metadata();
        final LogsPatternUsageService historicLogsUsageService = new LogsPatternUsageService(services.client(), this.settings, services.threadPool(), metadataSupplier);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)historicLogsUsageService);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                historicLogsUsageService.offMaster();
            }
        });
        return super.createComponents(services);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        this.logsdbIndexModeSettingsProvider.init((CheckedFunction<IndexMetadata, MapperService, IOException>)parameters.mapperServiceFactory(), () -> IndexVersion.min((IndexVersion)IndexVersion.current(), (IndexVersion)parameters.clusterService().state().nodes().getMaxDataNodeCompatibleIndexVersion()), () -> parameters.clusterService().state().nodes().getMinNodeVersion(), !DiscoveryNode.isStateless((Settings)this.settings), !DiscoveryNode.isStateless((Settings)this.settings));
        return List.of(this.logsdbIndexModeSettingsProvider);
    }

    public List<Setting<?>> getSettings() {
        return List.of(LogsdbLicenseService.FALLBACK_SETTING, CLUSTER_LOGSDB_ENABLED, LogsPatternUsageService.USAGE_CHECK_MAX_PERIOD, LogsPatternUsageService.LOGSDB_PRIOR_LOGS_USAGE);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.LOGSDB, LogsDBUsageTransportAction.class));
        actions.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.LOGSDB, LogsDBInfoTransportAction.class));
        return actions;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }
}

