/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.local;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.MonitoringTemplateRegistry;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringMigrationCoordinator;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalBulk;

public final class LocalExporter
extends Exporter
implements ClusterStateListener,
CleanerService.Listener,
LicenseStateListener {
    private static final Logger logger = LogManager.getLogger(LocalExporter.class);
    public static final String TYPE = "local";
    public static final Setting.AffixSetting<TimeValue> WAIT_MASTER_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"wait_master.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    private final Client client;
    private final ClusterService clusterService;
    private final XPackLicenseState licenseState;
    private final CleanerService cleanerService;
    private final DateFormatter dateTimeFormatter;
    private final List<String> clusterAlertBlacklist;
    private final boolean decommissionClusterAlerts;
    private final MonitoringMigrationCoordinator migrationCoordinator;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final AtomicBoolean installingSomething = new AtomicBoolean(false);
    private final AtomicBoolean watcherSetup = new AtomicBoolean(false);
    private final AtomicBoolean stateInitialized = new AtomicBoolean(false);
    private long stateInitializedTime;

    public LocalExporter(Exporter.Config config, Client client, MonitoringMigrationCoordinator migrationCoordinator, CleanerService cleanerService) {
        super(config);
        this.client = client;
        this.clusterService = config.clusterService();
        this.licenseState = config.licenseState();
        this.clusterAlertBlacklist = ClusterAlertsUtil.getClusterAlertsBlacklist(config);
        this.decommissionClusterAlerts = (Boolean)Monitoring.MIGRATION_DECOMMISSION_ALERTS.get(config.settings());
        this.migrationCoordinator = migrationCoordinator;
        this.cleanerService = cleanerService;
        this.dateTimeFormatter = LocalExporter.dateTimeFormatter(config);
        this.clusterService.addListener((ClusterStateListener)this);
        cleanerService.add(this);
        this.licenseState.addListener((LicenseStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) && !this.stateInitialized.getAndSet(true)) {
            this.stateInitializedTime = this.client.threadPool().relativeTimeInMillis();
        }
        if (this.state.get() == State.INITIALIZED && this.migrationCoordinator.canInstall()) {
            this.resolveBulk(event.state(), true);
        }
    }

    public void licenseStateChanged() {
        this.watcherSetup.set(false);
    }

    public boolean isExporterReady() {
        boolean running = this.resolveBulk(this.clusterService.state(), false) != null;
        boolean alertsProcessed = !this.canUseWatcher() || this.watcherSetup.get();
        return running && !this.installingSomething.get() && alertsProcessed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeAlerts(Consumer<Exporter.ExporterResourceStatus> listener) {
        if (this.state.get() == State.TERMINATED) {
            throw new IllegalStateException("Cannot refresh alerts on terminated exporter");
        }
        ClusterState clusterState = this.clusterService.state();
        if (!clusterState.nodes().isLocalNodeElectedMaster()) throw new ElasticsearchException("Cannot refresh alerts from nodes other than currently elected master.", new Object[0]);
        if (clusterState.blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.METADATA_WRITE)) {
            throw new ElasticsearchException("waiting until metadata writes are unblocked", new Object[0]);
        }
        assert (!this.migrationCoordinator.canInstall()) : "migration attempted while resources could be erroneously installed";
        ArrayList<Runnable> asyncActions = new ArrayList<Runnable>();
        AtomicInteger pendingResponses = new AtomicInteger(0);
        List<Exception> errors = Collections.synchronizedList(new ArrayList());
        this.removeClusterAlertsTasks(clusterState, listener, asyncActions, pendingResponses, errors);
        if (asyncActions.size() > 0) {
            if (!this.installingSomething.compareAndSet(false, true)) throw new ElasticsearchException("exporter is busy installing resources", new Object[0]);
            pendingResponses.set(asyncActions.size());
            try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("monitoring");){
                asyncActions.forEach(Runnable::run);
                return;
            }
        } else if (errors.size() > 0) {
            listener.accept(Exporter.ExporterResourceStatus.determineReadiness(this.name(), TYPE, errors));
            return;
        } else {
            listener.accept(Exporter.ExporterResourceStatus.ready(this.name(), TYPE));
        }
    }

    @Override
    public void openBulk(ActionListener<ExportBulk> listener) {
        if (this.state.get() != State.RUNNING) {
            TimeValue masterTimeout = (TimeValue)WAIT_MASTER_TIMEOUT_SETTING.getConcreteSettingForNamespace(this.config.name()).get(this.config.settings());
            TimeValue timeElapsed = TimeValue.timeValueMillis((long)(this.client.threadPool().relativeTimeInMillis() - this.stateInitializedTime));
            if (timeElapsed.compareTo(masterTimeout) > 0) {
                logger.info("waiting for elected master node [{}] to setup local exporter [{}] (does it have x-pack installed?)", (Object)this.clusterService.state().nodes().getMasterNode(), (Object)this.config.name());
            }
            listener.onResponse(null);
        } else {
            try {
                listener.onResponse((Object)this.resolveBulk(this.clusterService.state(), false));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    @Override
    public void doClose() {
        if (this.state.getAndSet(State.TERMINATED) != State.TERMINATED) {
            logger.trace("stopped");
            this.clusterService.removeListener((ClusterStateListener)this);
            this.cleanerService.remove(this);
            this.licenseState.removeListener((LicenseStateListener)this);
        }
    }

    LocalBulk resolveBulk(ClusterState clusterState, boolean clusterStateChange) {
        if (this.clusterService.localNode() == null || clusterState == null) {
            return null;
        }
        boolean setup = this.performSetup(clusterState, clusterStateChange);
        if (!setup) {
            return null;
        }
        if (this.state.compareAndSet(State.INITIALIZED, State.RUNNING)) {
            logger.debug("started");
            this.clusterService.removeListener((ClusterStateListener)this);
        }
        return new LocalBulk(this.name(), logger, this.client, this.dateTimeFormatter);
    }

    private boolean performSetup(ClusterState clusterState, boolean clusterStateChange) {
        boolean setup = this.clusterService.state().nodes().isLocalNodeElectedMaster() ? this.setupIfElectedMaster(clusterState, clusterStateChange) : this.setupIfNotElectedMaster(clusterState);
        return setup;
    }

    private boolean setupIfNotElectedMaster(ClusterState clusterState) {
        for (String template : MonitoringTemplateRegistry.TEMPLATE_NAMES) {
            if (LocalExporter.hasTemplate(clusterState, template)) continue;
            logger.debug("monitoring index template [{}] does not exist, so service cannot start (waiting on master)", (Object)template);
            return false;
        }
        logger.trace("monitoring index templates are installed, service can start");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setupIfElectedMaster(ClusterState clusterState, boolean clusterStateChange) {
        if (clusterState.blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.METADATA_WRITE)) {
            logger.debug("waiting until metadata writes are unblocked");
            return false;
        }
        if (!this.migrationCoordinator.canInstall()) {
            logger.debug("already installing something, waiting for migration to complete");
            return false;
        }
        if (this.installingSomething.get()) {
            logger.trace("already installing something, waiting for install to complete");
            return false;
        }
        ArrayList<Runnable> asyncActions = new ArrayList<Runnable>();
        AtomicInteger pendingResponses = new AtomicInteger(0);
        List<String> missingTemplates = Arrays.stream(MonitoringTemplateRegistry.TEMPLATE_NAMES).filter(name -> !LocalExporter.hasTemplate(clusterState, name)).toList();
        boolean templatesInstalled = false;
        if (!missingTemplates.isEmpty()) {
            logger.debug(() -> Strings.format((String)"monitoring index templates [%s] do not exist, so service cannot start (waiting on registered templates)", (Object[])new Object[]{missingTemplates}));
        } else {
            templatesInstalled = true;
        }
        this.setupClusterAlertsTasks(clusterState, clusterStateChange, asyncActions, pendingResponses);
        if (asyncActions.size() <= 0) {
            if (!templatesInstalled) return templatesInstalled;
            logger.debug("monitoring index templates are installed on master node, service can start");
            return templatesInstalled;
        }
        if (!this.installingSomething.compareAndSet(false, true)) {
            logger.trace("already installing something, waiting for install to complete");
            return false;
        }
        pendingResponses.set(asyncActions.size());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("monitoring");){
            asyncActions.forEach(Runnable::run);
            return templatesInstalled;
        }
    }

    private void setupClusterAlertsTasks(ClusterState clusterState, boolean clusterStateChange, List<Runnable> asyncActions, AtomicInteger pendingResponses) {
        boolean shouldSetUpWatcher;
        boolean bl = shouldSetUpWatcher = this.state.get() == State.RUNNING && !clusterStateChange;
        if (this.canUseWatcher()) {
            if (shouldSetUpWatcher) {
                boolean indexExists;
                IndexRoutingTable watches = clusterState.routingTable().index(".watches");
                boolean bl2 = indexExists = watches != null && watches.allPrimaryShardsActive();
                if (watches != null && !watches.allPrimaryShardsActive()) {
                    logger.trace("cannot manage cluster alerts because [.watches] index is not allocated");
                } else if ((watches == null || indexExists) && this.watcherSetup.compareAndSet(false, true)) {
                    logger.trace("installing monitoring watches");
                    this.getClusterAlertsInstallationAsyncActions(indexExists, asyncActions, pendingResponses);
                } else {
                    logger.trace("skipping installing monitoring watches, watches=[{}], indexExists=[{}], watcherSetup=[{}]", (Object)watches, (Object)indexExists, (Object)this.watcherSetup.get());
                }
            } else {
                logger.trace("watches shouldn't be setup, because state=[{}] and clusterStateChange=[{}]", (Object)this.state.get(), (Object)clusterStateChange);
            }
        } else {
            logger.trace("watches will not be installed because xpack.watcher.enabled=[{}] and xpack.monitoring.exporters._local.cluster_alerts.management.enabled=[{}]", XPackSettings.WATCHER_ENABLED.get(this.config.settings()), CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(this.config.name()).get(this.config.settings()));
        }
    }

    private void removeClusterAlertsTasks(ClusterState clusterState, Consumer<Exporter.ExporterResourceStatus> setupListener, List<Runnable> asyncActions, AtomicInteger pendingResponses, List<Exception> errors) {
        if (this.canUseWatcher()) {
            if (this.state.get() != State.TERMINATED) {
                boolean indexExists;
                IndexRoutingTable watches = clusterState.routingTable().index(".watches");
                boolean bl = indexExists = watches != null && watches.allPrimaryShardsActive();
                if (watches != null && !watches.allPrimaryShardsActive()) {
                    errors.add((Exception)new ElasticsearchException("cannot manage cluster alerts because [.watches] index is not allocated", new Object[0]));
                    logger.trace("cannot manage cluster alerts because [.watches] index is not allocated");
                } else if ((watches == null || indexExists) && this.watcherSetup.compareAndSet(false, true)) {
                    this.addClusterAlertsRemovalAsyncActions(indexExists, asyncActions, pendingResponses, setupListener, errors);
                }
            } else {
                errors.add((Exception)new ElasticsearchException("cannot manage cluster alerts because exporter is terminated", new Object[0]));
            }
        } else {
            errors.add((Exception)new ElasticsearchException("cannot manage cluster alerts because alerting is disabled", new Object[0]));
        }
    }

    private void responseReceived(AtomicInteger pendingResponses, boolean success, Runnable onComplete, @Nullable AtomicBoolean setup) {
        if (setup != null && !success) {
            setup.set(false);
        }
        if (pendingResponses.decrementAndGet() <= 0) {
            logger.trace("all installation requests returned a response");
            if (!this.installingSomething.compareAndSet(true, false)) {
                throw new IllegalStateException("could not reset installing flag to false");
            }
            onComplete.run();
        }
    }

    private static boolean hasTemplate(ClusterState clusterState, String templateName) {
        IndexTemplateMetadata template = (IndexTemplateMetadata)clusterState.getMetadata().getTemplates().get(templateName);
        return template != null && LocalExporter.hasValidVersion(template.getVersion(), 8120099L);
    }

    private static boolean hasValidVersion(Object version, long minimumVersion) {
        return version instanceof Number && (long)((Number)version).intValue() >= minimumVersion;
    }

    private void getClusterAlertsInstallationAsyncActions(boolean indexExists, List<Runnable> asyncActions, AtomicInteger pendingResponses) {
        boolean canAddWatches = Monitoring.MONITORING_CLUSTER_ALERTS_FEATURE.check(this.licenseState);
        for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
            boolean addWatch;
            String uniqueWatchId = ClusterAlertsUtil.createUniqueWatchId(this.clusterService, watchId);
            boolean bl = addWatch = canAddWatches && !this.clusterAlertBlacklist.contains(watchId) && !this.decommissionClusterAlerts;
            if (indexExists) {
                if (addWatch) {
                    logger.trace("checking monitoring watch [{}]", (Object)uniqueWatchId);
                    asyncActions.add(() -> this.client.execute((ActionType)GetWatchAction.INSTANCE, (ActionRequest)new GetWatchRequest(uniqueWatchId), (ActionListener)new GetAndPutWatchResponseActionListener(this.client, watchId, uniqueWatchId, pendingResponses)));
                    continue;
                }
                logger.trace("pruning monitoring watch [{}]", (Object)uniqueWatchId);
                asyncActions.add(() -> this.client.execute((ActionType)DeleteWatchAction.INSTANCE, (ActionRequest)new DeleteWatchRequest(uniqueWatchId), new ResponseActionListener("watch", uniqueWatchId, pendingResponses)));
                continue;
            }
            if (!addWatch) continue;
            logger.trace("adding monitoring watch [{}]", (Object)uniqueWatchId);
            asyncActions.add(() -> this.putWatch(this.client, watchId, uniqueWatchId, pendingResponses));
        }
    }

    private void addClusterAlertsRemovalAsyncActions(boolean indexExists, List<Runnable> asyncActions, AtomicInteger pendingResponses, Consumer<Exporter.ExporterResourceStatus> setupListener, List<Exception> errors) {
        for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
            String uniqueWatchId = ClusterAlertsUtil.createUniqueWatchId(this.clusterService, watchId);
            if (!indexExists) continue;
            logger.trace("pruning monitoring watch [{}]", (Object)uniqueWatchId);
            asyncActions.add(() -> this.client.execute((ActionType)DeleteWatchAction.INSTANCE, (ActionRequest)new DeleteWatchRequest(uniqueWatchId), new ErrorCapturingResponseListener("watch", uniqueWatchId, pendingResponses, setupListener, errors, this.name())));
        }
    }

    private void putWatch(Client clientToUse, String watchId, String uniqueWatchId, AtomicInteger pendingResponses) {
        String watch = ClusterAlertsUtil.loadWatch(this.clusterService, watchId);
        logger.trace("adding monitoring watch [{}]", (Object)uniqueWatchId);
        ClientHelper.executeAsyncWithOrigin((Client)clientToUse, (String)"monitoring", (ActionType)PutWatchAction.INSTANCE, (ActionRequest)new PutWatchRequest(uniqueWatchId, (BytesReference)new BytesArray(watch), XContentType.JSON), new ResponseActionListener("watch", uniqueWatchId, pendingResponses, this.watcherSetup));
    }

    private boolean canUseWatcher() {
        return (Boolean)XPackSettings.WATCHER_ENABLED.get(this.config.settings()) != false && (Boolean)CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(this.config.name()).get(this.config.settings()) != false;
    }

    @Override
    public void onCleanUpIndices(TimeValue retention) {
        if (!this.stateInitialized.get()) {
            logger.debug("exporter not yet initialized");
            return;
        }
        ClusterState clusterState = this.clusterService.state();
        if (this.clusterService.localNode() == null || clusterState == null || clusterState.blocks().hasGlobalBlockWithLevel(ClusterBlockLevel.METADATA_WRITE)) {
            logger.debug("exporter not ready");
            return;
        }
        if (clusterState.nodes().isLocalNodeElectedMaster()) {
            ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).minus(retention.millis(), ChronoUnit.MILLIS);
            logger.debug("cleaning indices [expiration={}, retention={}]", (Object)expiration, (Object)retention);
            long expirationTimeMillis = expiration.toInstant().toEpochMilli();
            long currentTimeMillis = System.currentTimeMillis();
            String[] indexPatterns = new String[]{".monitoring-*"};
            Set currents = MonitoredSystem.allSystems().map(s -> MonitoringTemplateUtils.indexName((DateFormatter)this.dateTimeFormatter, (MonitoredSystem)s, (long)currentTimeMillis)).collect(Collectors.toSet());
            currents.add(".monitoring-alerts-7");
            HashSet<String> indices = new HashSet<String>();
            for (Map.Entry index : clusterState.getMetadata().indices().entrySet()) {
                long creationDate;
                String indexName = (String)index.getKey();
                if (!Regex.simpleMatch((String[])indexPatterns, (String)indexName) || currents.contains(indexName) || (creationDate = ((IndexMetadata)index.getValue()).getCreationDate()) > expirationTimeMillis) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("detected expired index [name={}, created={}, expired={}]", (Object)indexName, (Object)Instant.ofEpochMilli(creationDate).atZone(ZoneOffset.UTC), (Object)expiration);
                }
                indices.add(indexName);
            }
            if (!indices.isEmpty()) {
                logger.info("cleaning up [{}] old indices", (Object)indices.size());
                this.deleteIndices(indices);
            } else {
                logger.debug("no old indices found for clean up");
            }
        }
    }

    private void deleteIndices(final Set<String> indices) {
        logger.trace("deleting {} indices: [{}]", (Object)indices.size(), (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(indices));
        DeleteIndexRequest request = new DeleteIndexRequest(indices.toArray(new String[indices.size()]));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (Object)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    logger.debug("{} indices deleted", (Object)indices.size());
                } else {
                    logger.warn("deletion of {} indices wasn't acknowledged", (Object)indices.size());
                }
            }

            public void onFailure(Exception e) {
                logger.error("failed to delete indices", (Throwable)e);
            }
        }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).delete(arg_0, arg_1));
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        return List.of(WAIT_MASTER_TIMEOUT_SETTING);
    }

    static enum State {
        INITIALIZED,
        RUNNING,
        TERMINATED;

    }

    private class ResponseActionListener<Response>
    implements ActionListener<Response> {
        protected final String type;
        protected final String name;
        private final AtomicInteger countDown;
        private final Runnable onComplete;
        private final AtomicBoolean setup;

        private ResponseActionListener(String type, String name, AtomicInteger countDown) {
            this(type, name, countDown, () -> {}, null);
        }

        private ResponseActionListener(String type, String name, AtomicInteger countDown, Runnable onComplete) {
            this(type, name, countDown, onComplete, null);
        }

        private ResponseActionListener(String type, String name, @Nullable AtomicInteger countDown, AtomicBoolean setup) {
            this(type, name, countDown, () -> {}, setup);
        }

        private ResponseActionListener(String type, String name, AtomicInteger countDown, @Nullable Runnable onComplete, AtomicBoolean setup) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.countDown = Objects.requireNonNull(countDown);
            this.onComplete = Objects.requireNonNull(onComplete);
            this.setup = setup;
        }

        public void onResponse(Response response) {
            if (response instanceof AcknowledgedResponse) {
                if (((AcknowledgedResponse)response).isAcknowledged()) {
                    logger.trace("successfully set monitoring {} [{}]", (Object)this.type, (Object)this.name);
                } else {
                    logger.error("failed to set monitoring {} [{}]", (Object)this.type, (Object)this.name);
                }
            } else {
                logger.trace("successfully handled monitoring {} [{}]", (Object)this.type, (Object)this.name);
            }
            LocalExporter.this.responseReceived(this.countDown, true, this.onComplete, this.setup);
        }

        public void onFailure(Exception e) {
            LocalExporter.this.responseReceived(this.countDown, false, this.onComplete, this.setup);
            logger.error(() -> Strings.format((String)"failed to set monitoring %s [%s]", (Object[])new Object[]{this.type, this.name}), (Throwable)e);
        }
    }

    private class ErrorCapturingResponseListener<Response>
    extends ResponseActionListener<Response> {
        private final List<Exception> errors;

        ErrorCapturingResponseListener(String type, String name, AtomicInteger countDown, Consumer<Exporter.ExporterResourceStatus> setupListener, List<Exception> errors, String configName) {
            super(type, name, countDown, () -> {
                Exporter.ExporterResourceStatus status = Exporter.ExporterResourceStatus.determineReadiness(configName, LocalExporter.TYPE, errors);
                setupListener.accept(status);
            });
            this.errors = errors;
        }

        @Override
        public void onResponse(Response response) {
            if (response instanceof AcknowledgedResponse && !((AcknowledgedResponse)response).isAcknowledged()) {
                this.errors.add((Exception)new ElasticsearchException("failed to set monitoring {} [{}]", new Object[]{this.type, this.name}));
            }
            super.onResponse(response);
        }

        @Override
        public void onFailure(Exception e) {
            this.errors.add((Exception)new ElasticsearchException("failed to set monitoring {} [{}]", (Throwable)e, new Object[]{this.type, this.name}));
            super.onFailure(e);
        }
    }

    private class GetAndPutWatchResponseActionListener
    implements ActionListener<GetWatchResponse> {
        private final Client client;
        private final String watchId;
        private final String uniqueWatchId;
        private final AtomicInteger countDown;

        private GetAndPutWatchResponseActionListener(Client client, String watchId, String uniqueWatchId, AtomicInteger countDown) {
            this.client = Objects.requireNonNull(client);
            this.watchId = Objects.requireNonNull(watchId);
            this.uniqueWatchId = Objects.requireNonNull(uniqueWatchId);
            this.countDown = Objects.requireNonNull(countDown);
        }

        public void onResponse(GetWatchResponse response) {
            if (response.isFound() && LocalExporter.hasValidVersion(response.getSource().getValue("metadata.xpack.version_created"), 7050099L)) {
                logger.trace("found monitoring watch [{}]", (Object)this.uniqueWatchId);
                LocalExporter.this.responseReceived(this.countDown, true, () -> {}, LocalExporter.this.watcherSetup);
            } else {
                LocalExporter.this.putWatch(this.client, this.watchId, this.uniqueWatchId, this.countDown);
            }
        }

        public void onFailure(Exception e) {
            LocalExporter.this.responseReceived(this.countDown, false, () -> {}, LocalExporter.this.watcherSetup);
            if (!(e instanceof IndexNotFoundException)) {
                logger.error(() -> "failed to get monitoring watch [" + this.uniqueWatchId + "]", (Throwable)e);
            }
        }
    }
}

