/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class StartsWithFunctionProcessor
implements Processor {
    public static final String NAME = "sstw";
    private final Processor source;
    private final Processor pattern;
    private final boolean caseInsensitive;

    public StartsWithFunctionProcessor(Processor source, Processor pattern, boolean caseInsensitive) {
        this.source = source;
        this.pattern = pattern;
        this.caseInsensitive = caseInsensitive;
    }

    public StartsWithFunctionProcessor(StreamInput in) throws IOException {
        this.source = (Processor)in.readNamedWriteable(Processor.class);
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.caseInsensitive = in.readBoolean();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.source);
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeBoolean(this.caseInsensitive);
    }

    @Override
    public Object process(Object input) {
        return StartsWithFunctionProcessor.doProcess(this.source.process(input), this.pattern.process(input), this.isCaseInsensitive());
    }

    public static Object doProcess(Object source, Object pattern, boolean caseInsensitive) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String) && !(source instanceof Character)) {
            throw new QlIllegalArgumentException("A string/char is required; received [{}]", source);
        }
        if (pattern == null) {
            return null;
        }
        if (!(pattern instanceof String) && !(pattern instanceof Character)) {
            throw new QlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (!caseInsensitive) {
            return source.toString().startsWith(pattern.toString());
        }
        return source.toString().toLowerCase(Locale.ROOT).startsWith(pattern.toString().toLowerCase(Locale.ROOT));
    }

    protected Processor source() {
        return this.source;
    }

    protected Processor pattern() {
        return this.pattern;
    }

    protected boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartsWithFunctionProcessor other = (StartsWithFunctionProcessor)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.isCaseInsensitive(), other.isCaseInsensitive());
    }

    public int hashCode() {
        return Objects.hash(this.source(), this.pattern(), this.isCaseInsensitive());
    }

    public String getWriteableName() {
        return NAME;
    }
}

