/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class Order
extends Expression {
    private final Expression child;
    private final OrderDirection direction;
    private final NullsPosition nulls;

    public Order(Source source, Expression child, OrderDirection direction, NullsPosition nulls) {
        super(source, Collections.singletonList(child));
        this.child = child;
        this.direction = direction;
        this.nulls = nulls == null ? NullsPosition.ANY : nulls;
    }

    @Override
    protected NodeInfo<Order> info() {
        return NodeInfo.create(this, Order::new, this.child, this.direction, this.nulls);
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isExact(this.child, "ORDER BY cannot be applied to field of data type [{}]: {}");
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Order replaceChildren(List<Expression> newChildren) {
        return new Order(this.source(), newChildren.get(0), this.direction, this.nulls);
    }

    public Expression child() {
        return this.child;
    }

    public OrderDirection direction() {
        return this.direction;
    }

    public NullsPosition nullsPosition() {
        return this.nulls;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.child, this.direction, this.nulls});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals((Object)this.nulls, (Object)other.nulls) && Objects.equals(this.child, other.child);
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }

    public static enum NullsPosition {
        FIRST,
        LAST,
        ANY;

    }
}

