/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import software.amazon.awssdk.regions.Region;

class S3DefaultRegionHolder {
    private static final Logger logger = LogManager.getLogger(S3DefaultRegionHolder.class);
    private Region defaultRegion;
    private Runnable defaultRegionFailureLogger = () -> {};
    private final Runnable initializer = new RunOnce(() -> {
        try {
            this.defaultRegion = (Region)delegateRegionSupplier.get();
            assert (this.defaultRegion != null);
        }
        catch (Exception e) {
            this.defaultRegion = null;
            this.defaultRegionFailureLogger = new RunOnce(() -> logger.warn("failed to obtain region from default provider chain", (Throwable)e));
        }
    });

    S3DefaultRegionHolder(Supplier<Region> delegateRegionSupplier) {
    }

    void start() {
        this.initializer.run();
    }

    Region getDefaultRegion() {
        assert (this.defaultRegion != null || this.defaultRegionFailureLogger instanceof RunOnce) : "not initialized";
        this.defaultRegionFailureLogger.run();
        return this.defaultRegion;
    }
}

