/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.action.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class GoogleVertexAiModel
extends RateLimitGroupingModel {
    private final GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings;
    protected URI nonStreamingUri;

    public GoogleVertexAiModel(ModelConfigurations configurations, ModelSecrets secrets, GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
    }

    public GoogleVertexAiModel(GoogleVertexAiModel model, ServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.nonStreamingUri = model.nonStreamingUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public GoogleVertexAiModel(GoogleVertexAiModel model, TaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
        this.nonStreamingUri = model.nonStreamingUri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public abstract ExecutableAction accept(GoogleVertexAiActionVisitor var1, Map<String, Object> var2);

    public GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public URI nonStreamingUri() {
        return this.nonStreamingUri;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings().rateLimitSettings();
    }
}

