/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio;

import java.io.IOException;
import java.util.concurrent.Flow;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.googleaistudio.GoogleAiStudioStreamingProcessor;
import org.elasticsearch.xpack.inference.services.googleaistudio.response.GoogleAiStudioErrorResponseEntity;

public class GoogleAiStudioResponseHandler
extends BaseResponseHandler {
    static final String GOOGLE_AI_STUDIO_UNAVAILABLE = "The Google AI Studio service may be temporarily overloaded or down";
    private final CheckedFunction<XContentParser, String, IOException> content;

    public GoogleAiStudioResponseHandler(String requestType, ResponseParser parseFunction) {
        this(requestType, parseFunction, false, (CheckedFunction<XContentParser, String, IOException>)((CheckedFunction)xContentParser -> {
            assert (false) : "do not call this";
            return "";
        }));
    }

    public GoogleAiStudioResponseHandler(String requestType, ResponseParser parseFunction, boolean canHandleStreamingResponses, CheckedFunction<XContentParser, String, IOException> content) {
        super(requestType, parseFunction, GoogleAiStudioErrorResponseEntity::fromResponse, canHandleStreamingResponses);
        this.content = content;
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 503) {
            throw new RetryException(true, this.buildError(GOOGLE_AI_STUDIO_UNAVAILABLE, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 404) {
            throw new RetryException(false, this.buildError(GoogleAiStudioResponseHandler.resourceNotFoundError(request), request, result));
        }
        if (statusCode == 403) {
            throw new RetryException(false, this.buildError("Received a permission denied error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static String resourceNotFoundError(Request request) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{request.getURI()});
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        GoogleAiStudioStreamingProcessor googleAiProcessor = new GoogleAiStudioStreamingProcessor(this.content);
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(googleAiProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)googleAiProcessor);
    }
}

