/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.response;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;

public class ElasticInferenceServiceAuthorizationResponseEntity
implements InferenceServiceResults {
    public static final String NAME = "elastic_inference_service_auth_results";
    private static final Logger logger = LogManager.getLogger(ElasticInferenceServiceAuthorizationResponseEntity.class);
    private static final String AUTH_FIELD_NAME = "authorized_models";
    private static final Map<String, TaskType> ELASTIC_INFERENCE_SERVICE_TASK_TYPE_MAPPING = Map.of("embed/text/sparse", TaskType.SPARSE_EMBEDDING, "chat", TaskType.CHAT_COMPLETION, "embed/text/dense", TaskType.TEXT_EMBEDDING, "rerank/text/text-similarity", TaskType.RERANK);
    public static ConstructingObjectParser<ElasticInferenceServiceAuthorizationResponseEntity, Void> PARSER = new ConstructingObjectParser(ElasticInferenceServiceAuthorizationResponseEntity.class.getSimpleName(), args -> new ElasticInferenceServiceAuthorizationResponseEntity((List)args[0]));
    private final List<AuthorizedModel> authorizedModels;

    public ElasticInferenceServiceAuthorizationResponseEntity(List<AuthorizedModel> authorizedModels) {
        this.authorizedModels = Objects.requireNonNull(authorizedModels);
    }

    public ElasticInferenceServiceAuthorizationResponseEntity() {
        this(List.of());
    }

    public ElasticInferenceServiceAuthorizationResponseEntity(StreamInput in) throws IOException {
        this(in.readCollectionAsList(AuthorizedModel::new));
    }

    public static ElasticInferenceServiceAuthorizationResponseEntity fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            ElasticInferenceServiceAuthorizationResponseEntity elasticInferenceServiceAuthorizationResponseEntity = (ElasticInferenceServiceAuthorizationResponseEntity)PARSER.apply(jsonParser, null);
            return elasticInferenceServiceAuthorizationResponseEntity;
        }
    }

    public List<AuthorizedModel> getAuthorizedModels() {
        return this.authorizedModels;
    }

    public String toString() {
        return this.authorizedModels.stream().map(AuthorizedModel::toString).collect(Collectors.joining(", "));
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        throw new UnsupportedOperationException();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.authorizedModels);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticInferenceServiceAuthorizationResponseEntity that = (ElasticInferenceServiceAuthorizationResponseEntity)o;
        return Objects.equals(this.authorizedModels, that.authorizedModels);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedModels);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> AuthorizedModel.AUTHORIZED_MODEL_PARSER.apply(arg_0, arg_1), new ParseField("models", new String[0]));
    }

    public record AuthorizedModel(String modelName, EnumSet<TaskType> taskTypes) implements Writeable,
    ToXContentObject
    {
        public static ConstructingObjectParser<AuthorizedModel, Void> AUTHORIZED_MODEL_PARSER = new ConstructingObjectParser(AuthorizedModel.class.getSimpleName(), args -> new AuthorizedModel((String)args[0], AuthorizedModel.toTaskTypes((List)args[1])));

        public AuthorizedModel(StreamInput in) throws IOException {
            this(in.readString(), in.readEnumSet(TaskType.class));
        }

        private static EnumSet<TaskType> toTaskTypes(List<String> stringTaskTypes) {
            EnumSet<TaskType> taskTypes = EnumSet.noneOf(TaskType.class);
            for (String taskType : stringTaskTypes) {
                TaskType mappedTaskType = ELASTIC_INFERENCE_SERVICE_TASK_TYPE_MAPPING.get(taskType);
                if (mappedTaskType == null) continue;
                taskTypes.add(mappedTaskType);
            }
            return taskTypes;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.modelName);
            out.writeEnumSet(this.taskTypes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("model_name", this.modelName);
            builder.field("task_types", (Collection)this.taskTypes.stream().map(TaskType::toString).collect(Collectors.toList()));
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.format((String)"{modelName='%s', taskTypes='%s'}", (Object[])new Object[]{this.modelName, this.taskTypes});
        }

        static {
            AUTHORIZED_MODEL_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("model_name", new String[0]));
            AUTHORIZED_MODEL_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("task_types", new String[0]));
        }
    }
}

