/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereUtils;

public abstract class CohereRequest
implements Request,
ToXContentObject {
    protected final CohereAccount account;
    private final String inferenceEntityId;
    private final String modelId;
    private final boolean stream;

    public static void decorateWithAuthHeader(HttpPost request, CohereAccount account) {
        request.setHeader("Content-Type", XContentType.JSON.mediaType());
        request.setHeader(RequestUtils.createAuthBearerHeader(account.apiKey()));
        request.setHeader(CohereUtils.createRequestSourceHeader());
    }

    protected CohereRequest(CohereAccount account, String inferenceEntityId, @Nullable String modelId, boolean stream) {
        this.account = account;
        this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
        this.modelId = modelId;
        this.stream = stream;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.getURI());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)this).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        CohereRequest.decorateWithAuthHeader(httpPost, this.account);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public boolean isStreaming() {
        return this.stream;
    }

    @Override
    public URI getURI() {
        return this.buildUri(this.account.baseUri());
    }

    protected abstract List<String> pathSegments();

    private URI buildUri(URI baseUri) {
        try {
            return new URIBuilder(baseUri).setPathSegments(this.pathSegments()).build();
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException(Strings.format((String)"Failed to construct %s URL", (Object[])new Object[]{"cohere"}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

