/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.util.List;
import java.util.Locale;

public enum SeparatorGroup {
    PLAINTEXT("plaintext"),
    MARKDOWN("markdown");

    private final String name;

    private SeparatorGroup(String name) {
        this.name = name;
    }

    public static SeparatorGroup fromString(String name) {
        return SeparatorGroup.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public List<String> getSeparators() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case PLAINTEXT -> List.of("(?<!\\n)\\n\\n(?!\\n)", "(?<!\\n)\\n(?!\\n)");
            case MARKDOWN -> List.of("\n# ", "\n## ", "\n### ", "\n#### ", "\n##### ", "\n###### ", "\n^(?!\\s*$).*\\n-{1,}\\n", "\n^(?!\\s*$).*\\n={1,}\\n");
        };
    }
}

