/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsOptions;

public class NoneChunkingSettings
implements ChunkingSettings {
    public static final String NAME = "NoneChunkingSettings";
    public static NoneChunkingSettings INSTANCE = new NoneChunkingSettings();
    private static final ChunkingStrategy STRATEGY = ChunkingStrategy.NONE;
    private static final Set<String> VALID_KEYS = Set.of(ChunkingSettingsOptions.STRATEGY.toString());
    private static final TransportVersion NONE_CHUNKING_STRATEGY = TransportVersion.fromName((String)"none_chunking_strategy");

    private NoneChunkingSettings() {
    }

    public ChunkingStrategy getChunkingStrategy() {
        return STRATEGY;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return NONE_CHUNKING_STRATEGY;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public Map<String, Object> asMap() {
        return Map.of(ChunkingSettingsOptions.STRATEGY.toString(), STRATEGY.toString().toLowerCase(Locale.ROOT));
    }

    public static NoneChunkingSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Object[] invalidSettings = map.keySet().stream().filter(key -> !VALID_KEYS.contains(key)).toArray();
        if (invalidSettings.length > 0) {
            validationException.addValidationError(Strings.format((String)"When chunking is disabled (none), settings can not have the following: %s", (Object[])new Object[]{Arrays.toString(invalidSettings)}));
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return INSTANCE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ChunkingSettingsOptions.STRATEGY.toString(), (Enum)STRATEGY);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.getClass());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

