/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.rest.action.user.NativeUserBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestPutUserAction
extends NativeUserBaseRestHandler
implements RestRequestFilter {
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Set.of("password", "password_hash");

    public RestPutUserAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/{username}").replaces(RestRequest.Method.PUT, "/_xpack/security/user/{username}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_put_user_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(final RestRequest request, NodeClient client) throws IOException {
        PutUserRequestBuilder requestBuilder = (PutUserRequestBuilder)new PutUserRequestBuilder((ElasticsearchClient)client).source(request.param("username"), (BytesReference)request.requiredContent(), request.getXContentType(), this.passwordHasher).setRefreshPolicy(request.param("refresh"));
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<PutUserResponse>(channel){

            public RestResponse buildResponse(PutUserResponse putUserResponse, XContentBuilder builder) throws Exception {
                putUserResponse.toXContent(builder, (ToXContent.Params)request);
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

