/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oidc;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutResponse;
import org.elasticsearch.xpack.security.rest.action.oidc.OpenIdConnectBaseRestHandler;

public class RestOpenIdConnectLogoutAction
extends OpenIdConnectBaseRestHandler {
    static final ObjectParser<OpenIdConnectLogoutRequest, Void> PARSER = new ObjectParser("oidc_logout", OpenIdConnectLogoutRequest::new);

    public RestOpenIdConnectLogoutAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/oidc/logout"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            OpenIdConnectLogoutRequest logoutRequest = (OpenIdConnectLogoutRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)OpenIdConnectLogoutAction.INSTANCE, (ActionRequest)logoutRequest, (ActionListener)new RestBuilderListener<OpenIdConnectLogoutResponse>(channel){

                public RestResponse buildResponse(OpenIdConnectLogoutResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    builder.field("redirect", response.getEndSessionUrl());
                    builder.endObject();
                    return new RestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "security_oidc_logout_action";
    }

    static {
        PARSER.declareString(OpenIdConnectLogoutRequest::setToken, new ParseField("token", new String[0]));
        PARSER.declareString(OpenIdConnectLogoutRequest::setRefreshToken, new ParseField("refresh_token", new String[0]));
    }
}

