/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public final class RestGrantApiKeyAction
extends ApiKeyBaseRestHandler
implements RestRequestFilter {
    private final RequestTranslator requestTranslator;

    public RestGrantApiKeyAction(Settings settings, XPackLicenseState licenseState, RequestTranslator requestTranslator) {
        super(settings, licenseState);
        this.requestTranslator = requestTranslator;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key/grant"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key/grant"));
    }

    public String getName() {
        return "xpack_security_grant_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        GrantApiKeyRequest grantRequest = this.requestTranslator.translate(request);
        String refresh = request.param("refresh");
        if (refresh != null) {
            grantRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)refresh));
        } else {
            grantRequest.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
        }
        return channel -> client.execute((ActionType)GrantApiKeyAction.INSTANCE, (ActionRequest)grantRequest, new RestToXContentListener(channel).delegateResponse((listener, ex) -> {
            RestStatus status = ExceptionsHelper.status((Throwable)ex);
            if (status == RestStatus.UNAUTHORIZED) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Failed to authenticate api key grant", RestStatus.FORBIDDEN, (Throwable)ex, new Object[0])));
            } else {
                listener.onFailure(ex);
            }
        }));
    }

    public Set<String> getFilteredFields() {
        return Set.of("password", "access_token", "client_authentication.value");
    }

    public static interface RequestTranslator {
        public GrantApiKeyRequest translate(RestRequest var1) throws IOException;

        public static class Default
        implements RequestTranslator {
            private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).build();
            private static final ObjectParser<GrantApiKeyRequest, Void> PARSER = Default.createParser((CheckedBiFunction<String, XContentParser, RoleDescriptor, IOException>)((CheckedBiFunction)(arg_0, arg_1) -> ((RoleDescriptor.Parser)ROLE_DESCRIPTOR_PARSER).parse(arg_0, arg_1)));

            protected static ObjectParser<GrantApiKeyRequest, Void> createParser(CheckedBiFunction<String, XContentParser, RoleDescriptor, IOException> roleDescriptorParser) {
                ConstructingObjectParser apiKeyParser = CreateApiKeyRequestBuilder.createParser(roleDescriptorParser);
                ObjectParser parser = new ObjectParser("grant_api_key_request", GrantApiKeyRequest::new);
                parser.declareString((req, str) -> req.getGrant().setType(str), new ParseField("grant_type", new String[0]));
                parser.declareString((req, str) -> req.getGrant().setUsername(str), new ParseField("username", new String[0]));
                parser.declareField((req, secStr) -> req.getGrant().setPassword(secStr), x$0 -> RestGrantApiKeyAction.getSecureString(x$0), new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
                parser.declareField((req, secStr) -> req.getGrant().setAccessToken(secStr), x$0 -> RestGrantApiKeyAction.getSecureString(x$0), new ParseField("access_token", new String[0]), ObjectParser.ValueType.STRING);
                parser.declareString((req, str) -> req.getGrant().setRunAsUsername(str), new ParseField("run_as", new String[0]));
                parser.declareObject((req, clientAuthentication) -> req.getGrant().setClientAuthentication(clientAuthentication), (ContextParser)CLIENT_AUTHENTICATION_PARSER, new ParseField("client_authentication", new String[0]));
                parser.declareObject(GrantApiKeyRequest::setApiKeyRequest, (p, ignore) -> (CreateApiKeyRequest)apiKeyParser.parse(p, null), new ParseField("api_key", new String[0]));
                return parser;
            }

            @Override
            public GrantApiKeyRequest translate(RestRequest request) throws IOException {
                try (XContentParser parser = request.contentParser();){
                    GrantApiKeyRequest grantApiKeyRequest = Default.fromXContent(parser);
                    return grantApiKeyRequest;
                }
            }

            public static GrantApiKeyRequest fromXContent(XContentParser parser) throws IOException {
                return (GrantApiKeyRequest)PARSER.parse(parser, null);
            }
        }
    }
}

