/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.security.authz.ReservedRoleNameChecker;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportGetRolesAction
extends TransportAction<GetRolesRequest, GetRolesResponse> {
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRoleNameChecker reservedRoleNameChecker;

    @Inject
    public TransportGetRolesAction(ActionFilters actionFilters, NativeRolesStore nativeRolesStore, ReservedRoleNameChecker reservedRoleNameChecker, TransportService transportService) {
        super("cluster:admin/xpack/security/role/get", actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRoleNameChecker = reservedRoleNameChecker;
    }

    protected void doExecute(Task task, GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        boolean specificRolesRequested;
        String[] requestedRoles = request.names();
        boolean bl = specificRolesRequested = requestedRoles != null && requestedRoles.length > 0;
        if (request.nativeOnly()) {
            Set<String> rolesToSearchFor;
            Set<String> set = rolesToSearchFor = specificRolesRequested ? Arrays.stream(requestedRoles).filter(r -> false == this.reservedRoleNameChecker.isReserved((String)r)).collect(Collectors.toSet()) : Collections.emptySet();
            if (specificRolesRequested && rolesToSearchFor.isEmpty()) {
                listener.onResponse((Object)new GetRolesResponse(new RoleDescriptor[0]));
            } else {
                this.getNativeRoles(rolesToSearchFor, listener);
            }
            return;
        }
        LinkedHashSet<String> rolesToSearchFor = new LinkedHashSet<String>();
        LinkedHashSet<RoleDescriptor> reservedRoles = new LinkedHashSet<RoleDescriptor>();
        if (specificRolesRequested) {
            for (String role : requestedRoles) {
                if (this.reservedRoleNameChecker.isReserved(role)) {
                    RoleDescriptor rd = ReservedRolesStore.roleDescriptor((String)role);
                    if (rd == null) continue;
                    reservedRoles.add(rd);
                    continue;
                }
                rolesToSearchFor.add(role);
            }
        } else {
            reservedRoles.addAll(ReservedRolesStore.roleDescriptors());
        }
        if (specificRolesRequested && rolesToSearchFor.isEmpty()) {
            listener.onResponse((Object)new GetRolesResponse(reservedRoles.toArray(new RoleDescriptor[0])));
        } else {
            this.getNativeRoles(rolesToSearchFor, reservedRoles, listener);
        }
    }

    private void getNativeRoles(Set<String> rolesToSearchFor, ActionListener<GetRolesResponse> listener) {
        this.getNativeRoles(rolesToSearchFor, new LinkedHashSet<RoleDescriptor>(), listener);
    }

    private void getNativeRoles(Set<String> rolesToSearchFor, Set<RoleDescriptor> foundRoles, ActionListener<GetRolesResponse> listener) {
        this.nativeRolesStore.getRoleDescriptors(rolesToSearchFor, (ActionListener<RoleRetrievalResult>)ActionListener.wrap(retrievalResult -> {
            if (retrievalResult.isSuccess()) {
                foundRoles.addAll(retrievalResult.getDescriptors());
                listener.onResponse((Object)new GetRolesResponse(foundRoles.toArray(new RoleDescriptor[0])));
            } else {
                listener.onFailure(retrievalResult.getFailure());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

