/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.eql.session.EmptyExecutable;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.eql.session.Executable;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;

public class LocalRelation
extends LogicalPlan
implements Executable {
    private final Executable executable;

    public LocalRelation(Source source, List<Attribute> output) {
        this(source, output, Payload.Type.EVENT);
    }

    public LocalRelation(Source source, List<Attribute> output, Payload.Type resultType) {
        this(source, new EmptyExecutable(output, resultType));
    }

    private LocalRelation(Source source, Executable executable) {
        super(source, Collections.emptyList());
        this.executable = executable;
    }

    protected NodeInfo<LocalRelation> info() {
        return NodeInfo.create((Node)this, LocalRelation::new, (Object)this.executable);
    }

    public LogicalPlan replaceChildren(List<LogicalPlan> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    public Executable executable() {
        return this.executable;
    }

    public boolean expressionsResolved() {
        return true;
    }

    @Override
    public List<Attribute> output() {
        return this.executable.output();
    }

    @Override
    public void execute(EqlSession session, ActionListener<Payload> listener) {
        this.executable.execute(session, listener);
    }

    public int hashCode() {
        return this.executable.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalRelation other = (LocalRelation)obj;
        return Objects.equals(this.executable, other.executable);
    }

    public String nodeString() {
        return this.nodeName() + NodeUtils.limitedToString(this.output());
    }
}

