/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.fulltext.MultiMatchQueryPredicate;

public class MultiMatchQuery
extends Query {
    private static final Map<String, BiConsumer<MultiMatchQueryBuilder, String>> BUILDER_APPLIERS = Map.ofEntries(Map.entry("slop", (qb, s) -> qb.slop(Integer.valueOf(s).intValue())), Map.entry("analyzer", MultiMatchQueryBuilder::analyzer), Map.entry("auto_generate_synonyms_phrase_query", (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s))), Map.entry("fuzziness", (qb, s) -> qb.fuzziness(Fuzziness.fromString((String)s))), Map.entry("fuzzy_rewrite", MultiMatchQueryBuilder::fuzzyRewrite), Map.entry("fuzzy_transpositions", (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s))), Map.entry("lenient", (qb, s) -> qb.lenient(Booleans.parseBoolean((String)s))), Map.entry("max_expansions", (qb, s) -> qb.maxExpansions(Integer.valueOf(s).intValue())), Map.entry("minimum_should_match", MultiMatchQueryBuilder::minimumShouldMatch), Map.entry("operator", (qb, s) -> qb.operator(Operator.fromString((String)s))), Map.entry("prefix_length", (qb, s) -> qb.prefixLength(Integer.valueOf(s).intValue())), Map.entry("tie_breaker", (qb, s) -> qb.tieBreaker(Float.valueOf(s))), Map.entry("type", MultiMatchQueryBuilder::type));
    private final String query;
    private final Map<String, Float> fields;
    private final Map<String, String> options;
    private final MultiMatchQueryPredicate predicate;

    public MultiMatchQuery(Source source, String query, Map<String, Float> fields, MultiMatchQueryPredicate predicate) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.predicate = predicate;
        this.options = predicate.optionMap();
    }

    protected QueryBuilder asBuilder() {
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)this.query, (String[])new String[0]);
        queryBuilder.fields(this.fields);
        queryBuilder.analyzer(this.predicate.analyzer());
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal multi_match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.fields, this.predicate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MultiMatchQuery other = (MultiMatchQuery)((Object)obj);
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.predicate, other.predicate);
    }

    protected String innerToString() {
        return String.valueOf(this.fields) + ":" + this.query;
    }

    public boolean containsPlan() {
        return false;
    }
}

