/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Join
extends BinaryPlan
implements PostAnalysisVerificationAware,
SortAgnostic {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Join", Join::new);
    public static final DataType[] UNSUPPORTED_TYPES = new DataType[]{DataType.TEXT, DataType.VERSION, DataType.UNSIGNED_LONG, DataType.GEO_POINT, DataType.GEO_SHAPE, DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE, DataType.UNSUPPORTED, DataType.NULL, DataType.COUNTER_LONG, DataType.COUNTER_INTEGER, DataType.COUNTER_DOUBLE, DataType.OBJECT, DataType.SOURCE, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.DOC_DATA_TYPE, DataType.TSID_DATA_TYPE, DataType.PARTIAL_AGG, DataType.AGGREGATE_METRIC_DOUBLE, DataType.DENSE_VECTOR};
    private final JoinConfig config;
    private List<Attribute> lazyOutput;

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right);
        this.config = config;
    }

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right);
        this.config = new JoinConfig(type, matchFields, leftFields, rightFields);
    }

    public Join(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class));
        this.config = new JoinConfig(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.left());
        out.writeNamedWriteable((NamedWriteable)this.right());
        this.config.writeTo(out);
    }

    public String getWriteableName() {
        return Join.ENTRY.name;
    }

    public JoinConfig config() {
        return this.config;
    }

    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, Join::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.config.type(), this.config.matchFields(), this.config.leftFields(), this.config.rightFields());
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = Join.computeOutput(this.left().output(), this.right().output(), this.config);
        }
        return this.lazyOutput;
    }

    @Override
    public AttributeSet leftReferences() {
        return Expressions.references(this.config().leftFields());
    }

    @Override
    public AttributeSet rightReferences() {
        return Expressions.references(this.config().rightFields());
    }

    public List<Attribute> rightOutputFields() {
        AttributeSet leftInputs = this.left().outputSet();
        ArrayList<Attribute> rightOutputFields = new ArrayList<Attribute>();
        for (Attribute attr : this.output()) {
            if (leftInputs.contains((Object)attr)) continue;
            rightOutputFields.add(attr);
        }
        return rightOutputFields;
    }

    public static List<Attribute> computeOutput(List<Attribute> leftOutput, List<Attribute> rightOutput, JoinConfig config) {
        JoinType joinType = config.type();
        if (!JoinTypes.LEFT.equals(joinType)) {
            throw new IllegalArgumentException(joinType.joinName() + " unsupported");
        }
        AttributeSet rightKeys = AttributeSet.of(config.rightFields());
        List<Attribute> rightOutputWithoutMatchFields = rightOutput.stream().filter(attr -> !rightKeys.contains(attr)).toList();
        List<Attribute> output = NamedExpressions.mergeOutputAttributes(rightOutputWithoutMatchFields, leftOutput);
        return output;
    }

    public static List<Attribute> makeReference(List<Attribute> output) {
        ArrayList<Attribute> out = new ArrayList<Attribute>(output.size());
        for (Attribute a : output) {
            if (a.resolved() && !(a instanceof ReferenceAttribute)) {
                out.add((Attribute)new ReferenceAttribute(a.source(), a.name(), a.dataType(), a.nullable(), a.id(), a.synthetic()));
                continue;
            }
            out.add(a);
        }
        return out;
    }

    @Override
    public boolean expressionsResolved() {
        return this.config.expressionsResolved();
    }

    @Override
    public boolean resolved() {
        return this.childrenResolved() && this.expressionsResolved();
    }

    public Join withConfig(JoinConfig config) {
        return new Join(this.source(), this.left(), this.right(), config);
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new Join(this.source(), left, right, this.config);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.config, this.left(), this.right()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        return this.config.equals(other.config) && Objects.equals((Object)this.left(), (Object)other.left()) && Objects.equals((Object)this.right(), (Object)other.right());
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        for (int i = 0; i < this.config.leftFields().size(); ++i) {
            Attribute rightField;
            Attribute leftField = this.config.leftFields().get(i);
            if (!Join.comparableTypes(leftField, rightField = this.config.rightFields().get(i))) {
                failures.add(Failure.fail(leftField, "JOIN left field [{}] of type [{}] is incompatible with right field [{}] of type [{}]", new Object[]{leftField.name(), leftField.dataType(), rightField.name(), rightField.dataType()}));
            }
            if (!Arrays.stream(UNSUPPORTED_TYPES).anyMatch(t -> rightField.dataType().equals(t))) continue;
            failures.add(Failure.fail(leftField, "JOIN with right field [{}] of type [{}] is not supported", new Object[]{rightField.name(), rightField.dataType()}));
        }
    }

    private static boolean comparableTypes(Attribute left, Attribute right) {
        DataType leftType = left.dataType();
        DataType rightType = right.dataType();
        if (leftType.isNumeric() && rightType.isNumeric()) {
            return EsqlDataTypeConverter.commonType(leftType, rightType) != null;
        }
        return leftType.noText() == rightType.noText();
    }
}

