/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string.regex;

import java.io.IOException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.WildcardPatternList;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.regex.RegexMatch;
import org.elasticsearch.xpack.esql.io.stream.ExpressionQuery;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class WildcardLikeList
extends RegexMatch<WildcardPatternList> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "WildcardLikeList", WildcardLikeList::new);
    Supplier<Automaton> automatonSupplier = new Supplier<Automaton>(){
        Automaton cached;

        @Override
        public Automaton get() {
            if (this.cached == null) {
                this.cached = ((WildcardPatternList)WildcardLikeList.this.pattern()).createAutomaton(WildcardLikeList.this.caseInsensitive());
            }
            return this.cached;
        }
    };
    Supplier<CharacterRunAutomaton> characterRunAutomatonSupplier = new Supplier<CharacterRunAutomaton>(){
        CharacterRunAutomaton cached;

        @Override
        public CharacterRunAutomaton get() {
            if (this.cached == null) {
                this.cached = new CharacterRunAutomaton(WildcardLikeList.this.automatonSupplier.get());
            }
            return this.cached;
        }
    };

    public WildcardLikeList(Source source, @Param(name="str", type={"keyword", "text"}, description="A literal expression.") Expression left, @Param(name="pattern", type={"keyword", "text"}, description="Pattern.") WildcardPatternList patterns) {
        this(source, left, patterns, false);
    }

    public WildcardLikeList(Source source, Expression left, WildcardPatternList patterns, boolean caseInsensitive) {
        super(source, left, patterns, caseInsensitive);
    }

    public WildcardLikeList(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), new WildcardPatternList(in), WildcardLikeList.deserializeCaseInsensitivity(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        ((WildcardPatternList)this.pattern()).writeTo(out);
        this.serializeCaseInsensitivity(out);
    }

    @Override
    public String name() {
        return WildcardLikeList.ENTRY.name;
    }

    public String getWriteableName() {
        return WildcardLikeList.ENTRY.name;
    }

    protected NodeInfo<WildcardLikeList> info() {
        return NodeInfo.create((Node)this, WildcardLikeList::new, (Object)this.field(), (Object)((WildcardPatternList)this.pattern()), (Object)this.caseInsensitive());
    }

    protected WildcardLikeList replaceChild(Expression newLeft) {
        return new WildcardLikeList(this.source(), newLeft, (WildcardPatternList)this.pattern(), this.caseInsensitive());
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        if (this.supportsPushdown(pushdownPredicates.minTransportVersion())) {
            return pushdownPredicates.isPushableAttribute(this.field()) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
        }
        return TranslationAware.Translatable.NO;
    }

    @Override
    public org.elasticsearch.xpack.esql.core.querydsl.query.Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        Expression expression;
        Expression field = this.field();
        LucenePushdownPredicates.checkIsPushableAttribute(field);
        if (field instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)field;
            expression = fa.exactAttribute();
        } else {
            expression = field;
        }
        String targetFieldName = handler.nameOf(expression);
        return this.translateField(targetFieldName);
    }

    private boolean supportsPushdown(TransportVersion version) {
        return version == null || WildcardQueryBuilder.expressionTransportSupported((TransportVersion)version);
    }

    @Override
    public Query asLuceneQuery(MappedFieldType fieldType, MultiTermQuery.RewriteMethod constantScoreRewrite, SearchExecutionContext context) {
        return fieldType.automatonQuery(this.automatonSupplier, this.characterRunAutomatonSupplier, constantScoreRewrite, context, this.getLuceneQueryDescription());
    }

    private String getLuceneQueryDescription() {
        String patternDesc = ((WildcardPatternList)this.pattern()).patternList().stream().map(WildcardPattern::pattern).collect(Collectors.joining("\", \""));
        return "LIKE(\"" + patternDesc + "\"), caseInsensitive=" + this.caseInsensitive();
    }

    private org.elasticsearch.xpack.esql.core.querydsl.query.Query translateField(String targetFieldName) {
        return new ExpressionQuery(this.source(), targetFieldName, (Expression)this);
    }
}

