/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCaseEvaluator;
import org.elasticsearch.xpack.esql.session.Configuration;

public abstract class ChangeCase
extends EsqlConfigurationFunction {
    private final Expression field;
    private final Case caseType;

    protected ChangeCase(Source source, Expression field, Configuration configuration, Case caseType) {
        super(source, List.of(field), configuration);
        this.field = field;
        this.caseType = caseType;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public boolean foldable() {
        return this.field.foldable();
    }

    public Expression field() {
        return this.field;
    }

    public Case caseType() {
        return this.caseType;
    }

    public abstract Expression replaceChild(Expression var1);

    public Expression replaceChildren(List<Expression> newChildren) {
        assert (newChildren.size() == 1);
        return this.replaceChild(newChildren.get(0));
    }

    static BytesRef process(BytesRef val, Locale locale, Case caseType) {
        return BytesRefs.toBytesRef((Object)caseType.process(val.utf8ToString(), locale));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new ChangeCaseEvaluator.Factory(this.source(), fieldEvaluator, this.configuration().locale(), this.caseType);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Case {
        UPPER{

            @Override
            String process(String value, Locale locale) {
                return value.toUpperCase(locale);
            }

            @Override
            public boolean matchesCase(String value) {
                return value.codePoints().allMatch(cp -> Character.getType(cp) != 2);
            }
        }
        ,
        LOWER{

            @Override
            String process(String value, Locale locale) {
                return value.toLowerCase(locale);
            }

            @Override
            public boolean matchesCase(String value) {
                return value.codePoints().allMatch(cp -> Character.getType(cp) != 1);
            }
        };


        abstract String process(String var1, Locale var2);

        public abstract boolean matchesCase(String var1);
    }
}

