/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileToLongFromStringEvaluator;

public class StGeotileToLong
extends AbstractConvertFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeotileToLong", StGeotileToLong::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, StGeotileToLongFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"long"}, description="Converts an input value representing a geotile grid-ID in string format into a long.", examples={@Example(file="spatial-grid", tag="geotile_to_long")})
    public StGeotileToLong(Source source, @Param(name="grid_id", type={"keyword", "long"}, description="Input geotile grid-id. The input can be a single- or multi-valued column or an expression.") Expression v) {
        super(source, v);
    }

    private StGeotileToLong(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StGeotileToLong.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StGeotileToLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeotileToLong::new, (Object)this.field());
    }

    static long fromString(BytesRef gridId) {
        return GeoTileUtils.longEncode((String)gridId.utf8ToString());
    }
}

