/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParseEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class DateParse
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DateParse", DateParse::new);
    private final Expression field;
    private final Expression format;

    @FunctionInfo(returnType={"date"}, description="Returns a date by parsing the second argument using the format specified in the first argument.", examples={@Example(file="docs", tag="dateParse")})
    public DateParse(Source source, @Param(name="datePattern", type={"keyword", "text"}, description="The date format. Refer to the\nhttps://docs.oracle.com/en/java/javase/14/docs/api/java.base/java/time/format/DateTimeFormatter.html[`DateTimeFormatter`\ndocumentation] for the syntax. If `null`, the function returns `null`.", optional=true) Expression first, @Param(name="dateString", type={"keyword", "text"}, description="Date expression as a string. If `null` or an empty string, the function returns `null`.") Expression second) {
        super(source, second != null ? List.of(first, second) : List.of(first));
        this.field = second != null ? second : first;
        this.format = second != null ? first : null;
    }

    private DateParse(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeOptionalNamedWriteable(this.children().size() == 2 ? (NamedWriteable)this.children().get(1) : null);
    }

    public String getWriteableName() {
        return DateParse.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DATETIME;
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.format != null && (resolution = EsqlTypeResolutions.isStringAndExact(this.format, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(this.format != null ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.FIRST));
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable() && (this.format == null || this.format.foldable());
    }

    public static long process(BytesRef val, DateFormatter formatter) throws IllegalArgumentException {
        return EsqlDataTypeConverter.dateTimeToLong(val.utf8ToString(), formatter);
    }

    static long process(BytesRef val, BytesRef formatter) throws IllegalArgumentException {
        return EsqlDataTypeConverter.dateTimeToLong(val.utf8ToString(), DateParse.toFormatter(formatter));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.format == null) {
            return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER);
        }
        if (!DataType.isString((DataType)this.format.dataType())) {
            throw new IllegalArgumentException("unsupported data type for date_parse [" + String.valueOf(this.format.dataType()) + "]");
        }
        if (this.format.foldable()) {
            try {
                DateFormatter formatter = DateParse.toFormatter(this.format.fold(toEvaluator.foldCtx()));
                return new DateParseConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidArgumentException((Throwable)e, "invalid date pattern for [{}]: {}", new Object[]{this.sourceText(), e.getMessage()});
            }
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(this.format);
        return new DateParseEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator);
    }

    private static DateFormatter toFormatter(Object format) {
        return DateFormatter.forPattern((String)((BytesRef)format).utf8ToString());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateParse(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        Expression first = this.format != null ? this.format : this.field;
        Expression second = this.format != null ? this.field : null;
        return NodeInfo.create((Node)this, DateParse::new, (Object)first, (Object)second);
    }
}

