/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.UnsupportedEsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public final class UnsupportedAttribute
extends FieldAttribute
implements Unresolvable {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "UnsupportedAttribute", UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry NAMED_EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(NamedExpression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    public static final NamedWriteableRegistry.Entry EXPRESSION_ENTRY = new NamedWriteableRegistry.Entry(Expression.class, UnsupportedAttribute.ENTRY.name, UnsupportedAttribute::readFrom);
    private final boolean hasCustomMessage;
    private final String message;

    private static String errorMessage(String name, UnsupportedEsField field) {
        return "Cannot use field [" + name + "] with unsupported type [" + String.join((CharSequence)",", field.getOriginalTypes()) + "]";
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field) {
        this(source, name, field, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage) {
        this(source, name, field, customMessage, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, @Nullable String customMessage, @Nullable NameId id) {
        super(source, null, name, (EsField)field, Nullability.TRUE, id, false);
        this.hasCustomMessage = customMessage != null;
        this.message = customMessage == null ? UnsupportedAttribute.errorMessage(this.name(), field) : customMessage;
    }

    private UnsupportedAttribute(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in)), PlanStreamInput.readCachedStringWithVersionCheck((StreamInput)in), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_2) ? (UnsupportedEsField)EsField.readFrom((StreamInput)in) : new UnsupportedEsField(in), in.readOptionalString(), NameId.readFrom((StreamInput)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader((Attribute)this)) {
            Source.EMPTY.writeTo(out);
            PlanStreamOutput.writeCachedStringWithVersionCheck((StreamOutput)out, (String)this.name());
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_2)) {
                this.field().writeTo(out);
            } else {
                this.field().writeContent(out);
            }
            out.writeOptionalString(this.hasCustomMessage ? this.message : null);
            this.id().writeTo(out);
        }
    }

    public static UnsupportedAttribute readFrom(StreamInput in) throws IOException {
        return (UnsupportedAttribute)((Object)((org.elasticsearch.xpack.esql.io.stream.PlanStreamInput)in).readAttributeWithCache(UnsupportedAttribute::new));
    }

    public String getWriteableName() {
        return UnsupportedAttribute.ENTRY.name;
    }

    public boolean resolved() {
        return false;
    }

    public UnsupportedEsField field() {
        return (UnsupportedEsField)super.field();
    }

    public FieldAttribute.FieldName fieldName() {
        if (this.lazyFieldName == null) {
            this.lazyFieldName = new FieldAttribute.FieldName(this.name());
        }
        return this.lazyFieldName;
    }

    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create((Node)this, UnsupportedAttribute::new, (Object)this.name(), (Object)this.field(), (Object)(this.hasCustomMessage ? this.message : null), (Object)this.id());
    }

    protected Attribute clone(Source source, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new UnsupportedAttribute(source, name, this.field(), this.hasCustomMessage ? this.message : null, id);
    }

    protected String label() {
        return "!";
    }

    public String toString() {
        return "!" + this.name();
    }

    public String nodeString() {
        return this.toString();
    }

    public String unresolvedMessage() {
        return this.message;
    }

    public boolean hasCustomMessage() {
        return this.hasCustomMessage;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasCustomMessage, this.message);
    }

    protected boolean innerEquals(Object o) {
        UnsupportedAttribute other = (UnsupportedAttribute)((Object)o);
        return super.innerEquals((Object)other) && this.hasCustomMessage == other.hasCustomMessage && Objects.equals(this.message, other.message);
    }

    public List<String> originalTypes() {
        return this.field().getOriginalTypes();
    }
}

