/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.util.function.BiFunction;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;

class LabelPositionVisitor
extends TriangleTreeVisitor.TriangleTreeDecodedVisitor {
    private SpatialPoint labelPosition;
    private final BiFunction<Double, Double, SpatialPoint> pointMaker;

    LabelPositionVisitor(CoordinateEncoder encoder, BiFunction<Double, Double, SpatialPoint> pointMaker) {
        super(encoder);
        this.pointMaker = pointMaker;
    }

    protected void visitDecodedPoint(double x, double y) {
        assert (this.labelPosition == null);
        this.labelPosition = this.pointMaker.apply(x, y);
    }

    protected void visitDecodedLine(double aX, double aY, double bX, double bY, byte metadata) {
        assert (this.labelPosition == null);
        this.labelPosition = this.pointMaker.apply((aX + bX) / 2.0, (aY + bY) / 2.0);
    }

    protected void visitDecodedTriangle(double aX, double aY, double bX, double bY, double cX, double cY, byte metadata) {
        assert (this.labelPosition == null);
        this.labelPosition = this.pointMaker.apply((aX + bX + cX) / 3.0, (aY + bY + cY) / 3.0);
    }

    protected boolean pushDecodedX(double minX) {
        return this.labelPosition == null;
    }

    protected boolean pushDecodedY(double minX) {
        return this.labelPosition == null;
    }

    public boolean push() {
        return this.labelPosition == null;
    }

    protected boolean pushDecoded(double maxX, double maxY) {
        return this.labelPosition == null;
    }

    protected boolean pushDecoded(double minX, double minY, double maxX, double maxY) {
        return this.labelPosition == null;
    }

    public SpatialPoint labelPosition() {
        return this.labelPosition;
    }
}

