/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.SumAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class StatsAggregator
extends NumericMetricsAggregator.MultiDoubleValue {
    final DocValueFormat format;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DoubleArray mins;
    DoubleArray maxes;

    StatsAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, metadata);
        assert (config.hasValues());
        this.counts = this.bigArrays().newLongArray(1L, true);
        this.sums = this.bigArrays().newDoubleArray(1L, true);
        this.compensations = this.bigArrays().newDoubleArray(1L, true);
        this.mins = this.bigArrays().newDoubleArray(1L, false);
        this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        this.maxes = this.bigArrays().newDoubleArray(1L, false);
        this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
        this.format = config.format();
    }

    @Override
    public LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    StatsAggregator.this.maybeGrow(bucket);
                    int valuesCount = values.docValueCount();
                    StatsAggregator.this.counts.increment(bucket, valuesCount);
                    double min = StatsAggregator.this.mins.get(bucket);
                    double max = StatsAggregator.this.maxes.get(bucket);
                    kahanSummation.reset(StatsAggregator.this.sums.get(bucket), StatsAggregator.this.compensations.get(bucket));
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    StatsAggregator.this.sums.set(bucket, kahanSummation.value());
                    StatsAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    StatsAggregator.this.mins.set(bucket, min);
                    StatsAggregator.this.maxes.set(bucket, max);
                }
            }
        };
    }

    @Override
    public LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        return new LeafBucketCollectorBase(sub, (Object)values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    StatsAggregator.this.maybeGrow(bucket);
                    StatsAggregator.this.counts.increment(bucket, 1L);
                    double value = values.doubleValue();
                    SumAggregator.computeSum(bucket, value, StatsAggregator.this.sums, StatsAggregator.this.compensations);
                    StatsAggregator.updateMinsAndMaxes(bucket, value, StatsAggregator.this.mins, StatsAggregator.this.maxes);
                }
            }
        };
    }

    static void updateMinsAndMaxes(long bucket, double value, DoubleArray mins, DoubleArray maxes) {
        double max;
        double min = mins.get(bucket);
        double updated = Math.min(value, min);
        if (updated != min) {
            mins.set(bucket, updated);
        }
        if ((updated = Math.max(value, max = maxes.get(bucket))) != max) {
            maxes.set(bucket, updated);
        }
    }

    private void maybeGrow(long bucket) {
        if (bucket >= this.counts.size()) {
            long from = this.counts.size();
            long overSize = BigArrays.overSize(bucket + 1L);
            BigArrays bigArrays = this.bigArrays();
            this.counts = bigArrays.resize(this.counts, overSize);
            this.sums = bigArrays.resize(this.sums, overSize);
            this.compensations = bigArrays.resize(this.compensations, overSize);
            this.mins = bigArrays.resize(this.mins, overSize);
            this.maxes = bigArrays.resize(this.maxes, overSize);
            this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
            this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public boolean hasMetric(String name) {
        return InternalStats.Metrics.hasMetric(name);
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        if (owningBucketOrd >= this.counts.size()) {
            return switch (InternalStats.Metrics.resolve(name)) {
                default -> throw new IncompatibleClassChangeError();
                case InternalStats.Metrics.count, InternalStats.Metrics.sum -> 0.0;
                case InternalStats.Metrics.min -> Double.POSITIVE_INFINITY;
                case InternalStats.Metrics.max -> Double.NEGATIVE_INFINITY;
                case InternalStats.Metrics.avg -> Double.NaN;
            };
        }
        return switch (InternalStats.Metrics.resolve(name)) {
            default -> throw new IncompatibleClassChangeError();
            case InternalStats.Metrics.count -> this.counts.get(owningBucketOrd);
            case InternalStats.Metrics.sum -> this.sums.get(owningBucketOrd);
            case InternalStats.Metrics.min -> this.mins.get(owningBucketOrd);
            case InternalStats.Metrics.max -> this.maxes.get(owningBucketOrd);
            case InternalStats.Metrics.avg -> this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalStats(this.name, this.counts.get(bucket), this.sums.get(bucket), this.mins.get(bucket), this.maxes.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalStats.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.maxes, this.mins, this.sums, this.compensations});
    }
}

