/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class SortedSetDocValuesStringFieldScript
extends StringFieldScript {
    private final SortedSetDocValues sortedSetDocValues;
    boolean hasValue = false;

    public SortedSetDocValuesStringFieldScript(String fieldName, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, Map.of(), searchLookup, OnScriptError.FAIL, ctx);
        try {
            this.sortedSetDocValues = DocValues.getSortedSet((LeafReader)ctx.reader(), (String)fieldName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public void setDocument(int docID) {
        try {
            this.hasValue = this.sortedSetDocValues.advanceExact(docID);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public void execute() {
        try {
            if (this.hasValue) {
                long ord;
                while ((ord = this.sortedSetDocValues.nextOrd()) != -1L) {
                    BytesRef bytesRef = this.sortedSetDocValues.lookupOrd(ord);
                    this.emit(bytesRef.utf8ToString());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

