/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class NodeMappingStats
implements Writeable,
ToXContentFragment {
    public static final NodeFeature SEGMENT_LEVEL_FIELDS_STATS = new NodeFeature("mapper.segment_level_fields_stats", true);
    private long totalCount;
    private long totalEstimatedOverhead;
    private long totalSegments;
    private long totalSegmentFields;

    public NodeMappingStats() {
    }

    public NodeMappingStats(StreamInput in) throws IOException {
        this.totalCount = in.readVLong();
        this.totalEstimatedOverhead = in.readVLong();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            this.totalSegments = in.readVLong();
            this.totalSegmentFields = in.readVLong();
        }
    }

    public NodeMappingStats(long totalCount, long totalEstimatedOverhead, long totalSegments, long totalSegmentFields) {
        this.totalCount = totalCount;
        this.totalEstimatedOverhead = totalEstimatedOverhead;
        this.totalSegments = totalSegments;
        this.totalSegmentFields = totalSegmentFields;
    }

    public void add(@Nullable NodeMappingStats other) {
        if (other == null) {
            return;
        }
        this.totalCount += other.totalCount;
        this.totalEstimatedOverhead += other.totalEstimatedOverhead;
        this.totalSegments += other.totalSegments;
        this.totalSegmentFields += other.totalSegmentFields;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public ByteSizeValue getTotalEstimatedOverhead() {
        return ByteSizeValue.ofBytes(this.totalEstimatedOverhead);
    }

    public long getTotalSegments() {
        return this.totalSegments;
    }

    public long getTotalSegmentFields() {
        return this.totalSegmentFields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCount);
        out.writeVLong(this.totalEstimatedOverhead);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0)) {
            out.writeVLong(this.totalSegments);
            out.writeVLong(this.totalSegmentFields);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mappings");
        builder.field("total_count", this.getTotalCount());
        builder.humanReadableField("total_estimated_overhead_in_bytes", "total_estimated_overhead", (Object)this.getTotalEstimatedOverhead());
        builder.field("total_segments", this.totalSegments);
        builder.field("total_segment_fields", this.totalSegmentFields);
        builder.field("average_fields_per_segment", this.totalSegments == 0L ? 0L : this.totalSegmentFields / this.totalSegments);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMappingStats that = (NodeMappingStats)o;
        return this.totalCount == that.totalCount && this.totalEstimatedOverhead == that.totalEstimatedOverhead && this.totalSegments == that.totalSegments && this.totalSegmentFields == that.totalSegmentFields;
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.totalEstimatedOverhead, this.totalSegments, this.totalSegmentFields);
    }

    private static final class Fields {
        static final String MAPPINGS = "mappings";
        static final String TOTAL_COUNT = "total_count";
        static final String TOTAL_ESTIMATED_OVERHEAD = "total_estimated_overhead";
        static final String TOTAL_ESTIMATED_OVERHEAD_IN_BYTES = "total_estimated_overhead_in_bytes";
        static final String TOTAL_SEGMENTS = "total_segments";
        static final String TOTAL_SEGMENT_FIELDS = "total_segment_fields";
        static final String AVERAGE_FIELDS_PER_SEGMENT = "average_fields_per_segment";

        private Fields() {
        }
    }
}

