/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DynamicTemplate
implements ToXContentObject {
    private final String name;
    private final List<String> pathMatch;
    private final List<String> pathUnmatch;
    private final List<String> match;
    private final List<String> unmatch;
    private final MatchType matchType;
    private final List<String> matchMappingType;
    private final List<String> unmatchMappingType;
    private final XContentFieldType[] xContentFieldTypes;
    private final Map<String, Object> mapping;
    private final boolean runtimeMapping;

    static DynamicTemplate parse(String name, Map<String, Object> conf) throws MapperParsingException {
        Stream<XContentFieldType> matchXContentFieldTypes;
        boolean wildcardMatchMappingType;
        ArrayList<String> match = new ArrayList<String>(4);
        ArrayList<String> pathMatch = new ArrayList<String>(4);
        ArrayList<String> unmatch = new ArrayList<String>(4);
        ArrayList<String> pathUnmatch = new ArrayList<String>(4);
        Map mapping = null;
        boolean runtime = false;
        ArrayList<String> matchMappingType = new ArrayList<String>(4);
        ArrayList<String> unmatchMappingType = new ArrayList<String>(4);
        String matchPattern = MatchType.DEFAULT.toString();
        for (Map.Entry<String, Object> entry : conf.entrySet()) {
            String propName = entry.getKey();
            if ("match".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(match, propName, entry);
                continue;
            }
            if ("path_match".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(pathMatch, propName, entry);
                continue;
            }
            if ("unmatch".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(unmatch, propName, entry);
                continue;
            }
            if ("path_unmatch".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(pathUnmatch, propName, entry);
                continue;
            }
            if ("match_mapping_type".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(matchMappingType, propName, entry);
                continue;
            }
            if ("unmatch_mapping_type".equals(propName)) {
                DynamicTemplate.addEntriesToPatternList(unmatchMappingType, propName, entry);
                continue;
            }
            if ("match_pattern".equals(propName)) {
                matchPattern = entry.getValue().toString();
                continue;
            }
            if ("mapping".equals(propName)) {
                if (mapping != null) {
                    throw new MapperParsingException("mapping and runtime cannot be both specified in the same dynamic template [" + name + "]");
                }
                mapping = (Map)entry.getValue();
                runtime = false;
                continue;
            }
            if ("runtime".equals(propName)) {
                if (mapping != null) {
                    throw new MapperParsingException("mapping and runtime cannot be both specified in the same dynamic template [" + name + "]");
                }
                mapping = (Map)entry.getValue();
                runtime = true;
                continue;
            }
            throw new IllegalArgumentException("Illegal dynamic template parameter: [" + propName + "]");
        }
        if (mapping == null) {
            throw new MapperParsingException("template [" + name + "] must have either mapping or runtime set");
        }
        boolean bl = wildcardMatchMappingType = matchMappingType.isEmpty() && DynamicTemplate.matchPatternsAreDefined(match, pathMatch, unmatchMappingType) || matchMappingType.size() == 1 && ((String)matchMappingType.get(0)).equals("*");
        if (wildcardMatchMappingType) {
            matchXContentFieldTypes = Stream.of(XContentFieldType.values());
            if (runtime) {
                matchXContentFieldTypes = matchXContentFieldTypes.filter(XContentFieldType::supportsRuntimeField);
            }
        } else {
            List<String> unsupported;
            if (runtime && !(unsupported = matchMappingType.stream().map(XContentFieldType::fromString).filter(Predicate.not(XContentFieldType::supportsRuntimeField)).map(XContentFieldType::toString).toList()).isEmpty()) {
                int numUnsupported = unsupported.size();
                throw new MapperParsingException("Dynamic template [" + name + "] defines a runtime field but type" + (numUnsupported == 1 ? "" : "s") + " [" + String.join((CharSequence)", ", unsupported) + "] " + (numUnsupported == 1 ? "is" : "are") + " not supported as runtime field");
            }
            matchXContentFieldTypes = matchMappingType.stream().map(XContentFieldType::fromString);
        }
        Set unmatchXContentFieldTypesSet = unmatchMappingType.stream().map(XContentFieldType::fromString).collect(Collectors.toSet());
        XContentFieldType[] xContentFieldTypes = (XContentFieldType[])matchXContentFieldTypes.filter(Predicate.not(unmatchXContentFieldTypesSet::contains)).toArray(XContentFieldType[]::new);
        MatchType matchType = MatchType.fromString(matchPattern);
        Stream.of(match, unmatch, pathMatch, pathUnmatch).flatMap(Collection::stream).forEach(pattern -> matchType.validate((String)pattern, name));
        return new DynamicTemplate(name, pathMatch, pathUnmatch, match, unmatch, matchMappingType, unmatchMappingType, xContentFieldTypes, matchType, mapping, runtime);
    }

    private static boolean matchPatternsAreDefined(List<?> ... matchLists) {
        return Stream.of(matchLists).anyMatch(Predicate.not(List::isEmpty));
    }

    private static void addEntriesToPatternList(List<String> matchList, String propName, Map.Entry<String, Object> entry) {
        Iterator iterator = entry.getValue();
        if (iterator instanceof List) {
            List ls = (List)((Object)iterator);
            for (Object o : ls) {
                if (o instanceof String) {
                    String s = (String)o;
                    matchList.add(s);
                    continue;
                }
                throw new MapperParsingException(Strings.format("[%s] values must either be a string or list of strings, but was [%s]", propName, entry.getValue()));
            }
        } else {
            matchList.add(entry.getValue().toString());
        }
    }

    private DynamicTemplate(String name, List<String> pathMatch, List<String> pathUnmatch, List<String> match, List<String> unmatch, List<String> matchMappingType, List<String> unmatchMappingType, XContentFieldType[] xContentFieldTypes, MatchType matchType, Map<String, Object> mapping, boolean runtimeMapping) {
        this.name = name;
        this.pathMatch = List.copyOf(pathMatch);
        this.pathUnmatch = List.copyOf(pathUnmatch);
        this.match = List.copyOf(match);
        this.unmatch = List.copyOf(unmatch);
        this.matchType = matchType;
        this.matchMappingType = List.copyOf(matchMappingType);
        this.unmatchMappingType = List.copyOf(unmatchMappingType);
        this.xContentFieldTypes = xContentFieldTypes;
        this.mapping = mapping;
        this.runtimeMapping = runtimeMapping;
    }

    public String name() {
        return this.name;
    }

    public List<String> pathMatch() {
        return this.pathMatch;
    }

    public List<String> match() {
        return this.match;
    }

    public boolean match(String templateName, String path, String fieldName, XContentFieldType xcontentFieldType) {
        if (templateName != null) {
            return templateName.equals(this.name);
        }
        if (!this.pathMatch.isEmpty() && !this.pathMatch.stream().anyMatch(m -> this.matchType.matches((String)m, path))) {
            return false;
        }
        if (!this.match.isEmpty() && !this.match.stream().anyMatch(m -> this.matchType.matches((String)m, fieldName))) {
            return false;
        }
        for (String um : this.pathUnmatch) {
            if (!this.matchType.matches(um, path)) continue;
            return false;
        }
        for (String um : this.unmatch) {
            if (!this.matchType.matches(um, fieldName)) continue;
            return false;
        }
        if (Arrays.stream(this.xContentFieldTypes).noneMatch(xcontentFieldType::equals)) {
            return false;
        }
        return !this.runtimeMapping || xcontentFieldType.supportsRuntimeField();
    }

    public String mappingType(String dynamicType) {
        Object index;
        String type;
        if (this.mapping.containsKey("type")) {
            type = this.mapping.get("type").toString();
            type = type.replace("{dynamic_type}", dynamicType);
            type = type.replace("{dynamicType}", dynamicType);
        } else {
            type = dynamicType;
        }
        if (!type.equals(this.mapping.get("type")) && "text".equals(type) && ("not_analyzed".equals(index = this.mapping.get("index")) || "no".equals(index))) {
            return "keyword";
        }
        return type;
    }

    public boolean isRuntimeMapping() {
        return this.runtimeMapping;
    }

    public Map<String, Object> mappingForName(String name, String dynamicType) {
        return DynamicTemplate.processMap(this.mapping, name, dynamicType);
    }

    private static Map<String, Object> processMap(Map<String, Object> map, String name, String dynamicType) {
        HashMap<String, Object> processedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
            processedMap.put(key, DynamicTemplate.extractValue(entry.getValue(), name, dynamicType));
        }
        return processedMap;
    }

    private static List<?> processList(List<?> list, String name, String dynamicType) {
        ArrayList<Object> processedList = new ArrayList<Object>(list.size());
        for (Object value : list) {
            processedList.add(DynamicTemplate.extractValue(value, name, dynamicType));
        }
        return processedList;
    }

    private static Object extractValue(Object value, String name, String dynamicType) {
        if (value instanceof Map) {
            return DynamicTemplate.processMap((Map)value, name, dynamicType);
        }
        if (value instanceof List) {
            return DynamicTemplate.processList((List)value, name, dynamicType);
        }
        if (value instanceof String) {
            return value.toString().replace("{name}", name).replace("{dynamic_type}", dynamicType).replace("{dynamicType}", dynamicType);
        }
        return value;
    }

    String getName() {
        return this.name;
    }

    XContentFieldType[] getXContentFieldTypes() {
        return this.xContentFieldTypes;
    }

    Map<String, Object> getMapping() {
        return this.mapping;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addStringOrArrayField(builder, "match", this.match);
        this.addStringOrArrayField(builder, "path_match", this.pathMatch);
        this.addStringOrArrayField(builder, "unmatch", this.unmatch);
        this.addStringOrArrayField(builder, "path_unmatch", this.pathUnmatch);
        this.addStringOrArrayField(builder, "match_mapping_type", this.matchMappingType);
        this.addStringOrArrayField(builder, "unmatch_mapping_type", this.unmatchMappingType);
        if (this.matchType != MatchType.DEFAULT) {
            builder.field("match_pattern", (Enum)this.matchType);
        }
        if (this.runtimeMapping) {
            builder.field("runtime", new TreeMap<String, Object>(this.mapping));
        } else {
            builder.field("mapping", new TreeMap<String, Object>(this.mapping));
        }
        builder.endObject();
        return builder;
    }

    private void addStringOrArrayField(XContentBuilder builder, String fieldName, List<String> list) throws IOException {
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                builder.field(fieldName, list.get(0));
            } else {
                builder.field(fieldName, list);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MatchType {
        DEFAULT{

            @Override
            public boolean matches(String pattern, String value) {
                return SIMPLE.matches(pattern, value);
            }

            public String toString() {
                return "default";
            }

            @Override
            public void validate(String pattern, String templateName) {
                if (pattern.startsWith("*")) {
                    return;
                }
                boolean regexCandidate = false;
                if (pattern.startsWith(".*")) {
                    regexCandidate = true;
                } else if (pattern.contains("^")) {
                    regexCandidate = true;
                } else if (pattern.contains("$")) {
                    regexCandidate = true;
                } else if (pattern.contains("|")) {
                    regexCandidate = true;
                } else if (pattern.contains("[") && pattern.contains("]")) {
                    regexCandidate = true;
                } else if (pattern.contains("{") && pattern.contains("}")) {
                    regexCandidate = true;
                }
                if (regexCandidate) {
                    try {
                        Pattern.compile(pattern);
                        String warning = "Pattern [" + pattern + "] in dynamic template [" + templateName + "] appears to be a regular expression, not a simple wildcard pattern. To remove this warning, set [match_pattern] in the dynamic template.";
                        HeaderWarning.addWarning(warning, new Object[0]);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        ,
        SIMPLE{

            @Override
            public boolean matches(String pattern, String value) {
                return Regex.simpleMatch(pattern, value);
            }

            public String toString() {
                return "simple";
            }

            @Override
            public void validate(String pattern, String templateName) {
            }
        }
        ,
        REGEX{

            @Override
            public boolean matches(String pattern, String value) {
                return value.matches(pattern);
            }

            public String toString() {
                return "regex";
            }

            @Override
            public void validate(String pattern, String templateName) {
                try {
                    this.matches(pattern, "");
                }
                catch (PatternSyntaxException e) {
                    throw new MapperParsingException(Strings.format("Pattern [%s] of type [regex] is invalid. Cannot create dynamic template [%s].", pattern, templateName), e);
                }
            }
        };


        public static MatchType fromString(String value) {
            for (MatchType v : MatchType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No matching pattern matched on [" + value + "]");
        }

        public abstract boolean matches(String var1, String var2);

        public abstract void validate(String var1, String var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum XContentFieldType {
        OBJECT{

            @Override
            boolean supportsRuntimeField() {
                return false;
            }
        }
        ,
        STRING{

            @Override
            public String defaultMappingType() {
                return "text";
            }

            @Override
            String defaultRuntimeMappingType() {
                return "keyword";
            }
        }
        ,
        LONG,
        DOUBLE{

            @Override
            public String defaultMappingType() {
                return NumberFieldMapper.NumberType.FLOAT.typeName();
            }
        }
        ,
        BOOLEAN,
        DATE,
        BINARY{

            @Override
            boolean supportsRuntimeField() {
                return false;
            }
        };


        public static XContentFieldType fromString(String value) {
            for (XContentFieldType v : XContentFieldType.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            throw new IllegalArgumentException("No field type matched on [" + value + "], possible values are " + Arrays.toString((Object[])XContentFieldType.values()));
        }

        String defaultMappingType() {
            return this.toString();
        }

        String defaultRuntimeMappingType() {
            return this.toString();
        }

        boolean supportsRuntimeField() {
            return true;
        }

        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

