/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentType;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    public static final String NAME = "indices:data/write/update";
    public static final ActionType<UpdateResponse> TYPE = new ActionType("indices:data/write/update");
    private final AutoCreateIndex autoCreateIndex;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;
    private final NodeClient client;

    @Inject
    public TransportUpdateAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, AutoCreateIndex autoCreateIndex, NodeClient client) {
        super(NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateRequest::new);
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
    }

    @Override
    protected Executor executor(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return this.threadPool.executor(indexService.getIndexSettings().getIndexMetadata().isSystem() ? "system_write" : "write");
    }

    @Override
    protected UpdateResponse newResponse(StreamInput in) throws IOException {
        return new UpdateResponse(in);
    }

    @Override
    protected boolean retryOnFailure(Exception e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected void resolveRequest(ClusterState state, UpdateRequest docWriteRequest) {
        docWriteRequest.routing(state.metadata().resolveWriteIndexRouting(docWriteRequest.routing(), docWriteRequest.index()));
    }

    @Override
    protected void doExecute(final Task task, final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (request.isRequireAlias() && !this.clusterService.state().getMetadata().hasAlias(request.index())) {
            throw new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
        }
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            this.client.admin().indices().create((CreateIndexRequest)new CreateIndexRequest().index(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(task, request, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(task, request, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    private void innerExecute(Task task, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) {
        if (request.getShardId() != null) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(request.getShardId().getId()).primaryShardIt();
        }
        IndexMetadata indexMetadata = clusterState.metadata().index(request.concreteIndex());
        if (indexMetadata == null) {
            throw new IndexNotFoundException(request.concreteIndex());
        }
        IndexRouting indexRouting = IndexRouting.fromIndexMetadata(indexMetadata);
        int shardId = indexRouting.updateShard(request.id(), request.routing());
        return RoutingTable.shardRoutingTable(clusterState.routingTable().index(request.concreteIndex()), shardId).primaryShardIt();
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        try {
            this.shardOperation(request, listener, 0);
        }
        catch (IOException e) {
            listener.onFailure(e);
        }
    }

    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener, int retryCount) throws IOException {
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        MappingLookup mappingLookup = indexShard.mapperService().mappingLookup();
        UpdateHelper.Result result = TransportUpdateAction.deleteInferenceResults(request, this.updateHelper.prepare(request, indexShard, this.threadPool::absoluteTimeInMillis), indexService.getMetadata(), mappingLookup);
        switch (result.getResponseResult()) {
            case CREATED: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                BytesReference upsertSourceBytes = upsertRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(upsertRequest), TransportBulkAction.unwrappingSingleItemBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true, upsertRequest.getContentType());
                        update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), mappingLookup, response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), upsertSourceBytes));
                    } else {
                        update.setGetResult(null);
                    }
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                BytesReference indexSourceBytes = indexRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(indexRequest), TransportBulkAction.unwrappingSingleItemBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), mappingLookup, response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(deleteRequest), TransportBulkAction.unwrappingSingleItemBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), mappingLookup, response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case NOOP: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(shardId.getIndex());
                if (indexServiceOrNull != null && (shard = indexService.getShardOrNull(shardId.getId())) != null) {
                    shard.noopUpdate();
                }
                listener.onResponse(update);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal result " + String.valueOf(result.getResponseResult()));
            }
        }
    }

    private void handleUpdateFailureWithRetry(ActionListener<UpdateResponse> listener, UpdateRequest request, Exception failure, int retryCount) {
        Throwable cause = ExceptionsHelper.unwrapCause(failure);
        if (cause instanceof VersionConflictEngineException) {
            VersionConflictEngineException versionConflictEngineException = (VersionConflictEngineException)cause;
            if (retryCount < request.retryOnConflict()) {
                Executor executor;
                this.logger.trace("Retry attempt [{}] of [{}] on version conflict on [{}][{}][{}]", (Object)(retryCount + 1), (Object)request.retryOnConflict(), (Object)request.index(), (Object)request.getShardId(), (Object)request.id());
                try {
                    executor = this.executor(request.getShardId());
                }
                catch (Exception e) {
                    e.addSuppressed(versionConflictEngineException);
                    listener.onFailure(e);
                    return;
                }
                executor.execute(ActionRunnable.wrap(listener, l -> this.shardOperation(request, (ActionListener<UpdateResponse>)l, retryCount + 1)));
                return;
            }
        }
        listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
    }

    private static UpdateHelper.Result deleteInferenceResults(UpdateRequest updateRequest, UpdateHelper.Result result, IndexMetadata indexMetadata, MappingLookup mappingLookup) {
        if (result.getResponseResult() != DocWriteResponse.Result.UPDATED || InferenceMetadataFieldsMapper.isEnabled(mappingLookup)) {
            return result;
        }
        Map<String, InferenceFieldMetadata> inferenceFields = indexMetadata.getInferenceFields();
        if (inferenceFields.isEmpty()) {
            return result;
        }
        if (updateRequest.script() != null) {
            throw new ElasticsearchStatusException("Cannot apply update with a script on indices that contain inference field(s)", RestStatus.BAD_REQUEST, new Object[0]);
        }
        IndexRequest doc = updateRequest.doc();
        if (doc == null) {
            return result;
        }
        Map<String, Object> updateRequestSource = doc.sourceAsMap();
        Map<String, Object> updatedSource = result.updatedSourceAsMap();
        boolean updatedSourceModified = false;
        block0: for (Map.Entry<String, InferenceFieldMetadata> entry : inferenceFields.entrySet()) {
            String inferenceFieldName = entry.getKey();
            Mapper mapper = mappingLookup.getMapper(inferenceFieldName);
            if (mapper instanceof InferenceFieldMapper) {
                String[] sourceFields;
                for (String sourceField : sourceFields = entry.getValue().getSourceFields()) {
                    if (sourceField.equals(inferenceFieldName) || XContentMapValues.extractValue(sourceField, updateRequestSource) == null) continue;
                    updatedSource.put(inferenceFieldName, TransportUpdateAction.getOriginalValueLegacy(inferenceFieldName, updatedSource));
                    updatedSourceModified = true;
                    continue block0;
                }
                continue;
            }
            throw new IllegalStateException("Field [" + inferenceFieldName + "] is of type [ " + mapper.typeName() + "], which is not an inference field");
        }
        UpdateHelper.Result returnedResult = result;
        if (updatedSourceModified) {
            XContentType contentType = result.updateSourceContentType();
            IndexRequest indexRequest = (IndexRequest)result.action();
            indexRequest.source(updatedSource, contentType);
            returnedResult = new UpdateHelper.Result(indexRequest, result.getResponseResult(), updatedSource, contentType);
        }
        return returnedResult;
    }

    private static Object getOriginalValueLegacy(String fullPath, Map<String, Object> sourceAsMap) {
        Object fieldValue = sourceAsMap.get(fullPath);
        if (fieldValue == null) {
            return null;
        }
        if (!(fieldValue instanceof Map)) {
            return fieldValue;
        }
        Map<String, Object> fieldValueMap = XContentMapValues.nodeMapValue(fieldValue, "Field [" + fullPath + "]");
        return XContentMapValues.extractValue("text", fieldValueMap);
    }
}

