/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public abstract class BroadcastShardRequest
extends TransportRequest
implements IndicesRequest {
    private final ShardId shardId;
    protected OriginalIndices originalIndices;

    public BroadcastShardRequest(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    protected BroadcastShardRequest(ShardId shardId, BroadcastRequest<? extends BroadcastRequest<?>> request) {
        this.shardId = shardId;
        this.originalIndices = new OriginalIndices(request);
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }
}

