/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    public static final ActionType<ExplainResponse> TYPE = new ActionType("indices:data/read/explain");
    private final SearchService searchService;
    private final RemoteClusterService remoteClusterService;

    @Inject
    public TransportExplainAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchService searchService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest::new, threadPool.executor("get"));
        this.searchService = searchService;
        this.remoteClusterService = transportService.getRemoteClusterService();
    }

    @Override
    protected void doExecute(Task task, ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        ResolvedIndices resolvedIndices = ResolvedIndices.resolveWithIndicesRequest(request, this.clusterService.state(), this.indexNameExpressionResolver, this.remoteClusterService, request.nowInMillis);
        ActionListener<QueryBuilder> rewriteListener = listener.delegateFailureAndWrap((l, rewrittenQuery) -> {
            request.query((QueryBuilder)rewrittenQuery);
            super.doExecute(task, request, l);
        });
        assert (request.query() != null);
        LongSupplier timeProvider = () -> request.nowInMillis;
        Rewriteable.rewriteAndFetch(request.query(), this.searchService.getRewriteContext(timeProvider, resolvedIndices, null), rewriteListener);
    }

    @Override
    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(state, ((ExplainRequest)request.request()).index());
        AliasFilter aliasFilter = this.searchService.buildAliasFilter(state, request.concreteIndex(), indicesAndAliases);
        ((ExplainRequest)request.request()).filteringAlias(aliasFilter);
    }

    @Override
    protected void asyncShardOperation(ExplainRequest request, ShardId shardId, ActionListener<ExplainResponse> listener) throws IOException {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        indexShard.ensureShardSearchActive(b -> {
            try {
                super.asyncShardOperation(request, shardId, listener);
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        });
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) throws IOException {
        ExplainResponse explainResponse;
        Explanation explanation;
        Engine.GetResult result;
        SearchContext context;
        block8: {
            block7: {
                ShardSearchRequest shardSearchLocalRequest = new ShardSearchRequest(shardId, request.nowInMillis, request.filteringAlias());
                context = this.searchService.createSearchContext(shardSearchLocalRequest, SearchService.NO_TIMEOUT);
                result = null;
                result = context.indexShard().get(new Engine.Get(false, false, request.id()));
                if (result.exists()) break block7;
                ExplainResponse explainResponse2 = new ExplainResponse(shardId.getIndexName(), request.id(), false);
                Releasables.close((Releasable[])new Releasable[]{result, context});
                return explainResponse2;
            }
            context.parsedQuery(context.getSearchExecutionContext().toQuery(request.query()));
            context.preProcess();
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().docBase;
            explanation = context.searcher().explain(context.rewrittenQuery(), topLevelDocId);
            for (RescoreContext ctx : context.rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, context.searcher(), ctx, explanation);
            }
            if (request.storedFields() == null && (request.fetchSourceContext() == null || !request.fetchSourceContext().fetchSource())) break block8;
            GetResult getResult = context.indexShard().getService().get(result, request.id(), request.storedFields(), request.fetchSourceContext());
            ExplainResponse explainResponse3 = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation, getResult);
            Releasables.close((Releasable[])new Releasable[]{result, context});
            return explainResponse3;
        }
        try {
            explainResponse = new ExplainResponse(shardId.getIndexName(), request.id(), true, explanation);
        }
        catch (IOException e) {
            try {
                throw new ElasticsearchException("Could not explain", (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                Releasables.close((Releasable[])new Releasable[]{result, context});
                throw throwable;
            }
        }
        Releasables.close((Releasable[])new Releasable[]{result, context});
        return explainResponse;
    }

    @Override
    protected Writeable.Reader<ExplainResponse> getResponseReader() {
        return ExplainResponse::new;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }

    @Override
    protected Executor getExecutor(ExplainRequest request, ShardId shardId) {
        IndexService indexService = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? this.threadPool.executor("search_throttled") : super.getExecutor(request, shardId);
    }
}

