/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public class LegacyDocValuesIterables {
    private LegacyDocValuesIterables() {
    }

    @Deprecated
    public static Iterable<BytesRef> valuesIterable(final SortedDocValues values) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    private int nextOrd;

                    @Override
                    public boolean hasNext() {
                        return this.nextOrd < values.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        try {
                            return values.lookupOrd(this.nextOrd++);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<BytesRef> valuesIterable(final SortedSetDocValues values) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    private long nextOrd;

                    @Override
                    public boolean hasNext() {
                        return this.nextOrd < values.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        try {
                            return values.lookupOrd(this.nextOrd++);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedOrdIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedDocValues values;
                try {
                    values = valuesProducer.getSorted(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values.docID()) {
                                values.nextDoc();
                            }
                            int result = this.nextDocID == values.docID() ? values.ordValue() : -1;
                            ++this.nextDocID;
                            return result;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedSetOrdCountIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedSetDocValues values;
                try {
                    values = valuesProducer.getSortedSet(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;
                    private int ordCount;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values.docID() && values.nextDoc() != Integer.MAX_VALUE) {
                                this.ordCount = 0;
                                while (values.nextOrd() != -1L) {
                                    ++this.ordCount;
                                }
                            }
                            int result = this.nextDocID == values.docID() ? this.ordCount : 0;
                            ++this.nextDocID;
                            return result;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedSetOrdsIterable(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedSetDocValues values;
                try {
                    values = valuesProducer.getSortedSet(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private boolean nextIsSet;
                    private long nextOrd;

                    private void setNext() {
                        try {
                            if (!this.nextIsSet) {
                                if (values.docID() == -1) {
                                    values.nextDoc();
                                }
                                while (true) {
                                    if (values.docID() == Integer.MAX_VALUE) {
                                        this.nextOrd = -1L;
                                        break;
                                    }
                                    this.nextOrd = values.nextOrd();
                                    if (this.nextOrd != -1L) break;
                                    values.nextDoc();
                                }
                                this.nextIsSet = true;
                            }
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.setNext();
                        return this.nextOrd != -1L;
                    }

                    @Override
                    public Number next() {
                        this.setNext();
                        assert (this.nextOrd != -1L);
                        this.nextIsSet = false;
                        return this.nextOrd;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedNumericToDocCount(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedNumericDocValues values;
                try {
                    values = valuesProducer.getSortedNumeric(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int nextDocID;

                    @Override
                    public boolean hasNext() {
                        return this.nextDocID < maxDoc;
                    }

                    @Override
                    public Number next() {
                        try {
                            if (this.nextDocID > values.docID()) {
                                values.nextDoc();
                            }
                            int result = this.nextDocID == values.docID() ? values.docValueCount() : 0;
                            ++this.nextDocID;
                            return result;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> sortedNumericToValues(final DocValuesProducer valuesProducer, final FieldInfo fieldInfo) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                SortedNumericDocValues values;
                try {
                    values = valuesProducer.getSortedNumeric(fieldInfo);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private boolean nextIsSet;
                    private int nextCount;
                    private int upto;
                    private long nextValue;

                    private void setNext() {
                        try {
                            if (!this.nextIsSet) {
                                if (this.upto == this.nextCount) {
                                    values.nextDoc();
                                    if (values.docID() == Integer.MAX_VALUE) {
                                        this.nextCount = 0;
                                        this.nextIsSet = false;
                                        return;
                                    }
                                    this.nextCount = values.docValueCount();
                                    this.upto = 0;
                                }
                                this.nextValue = values.nextValue();
                                ++this.upto;
                                this.nextIsSet = true;
                            }
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.setNext();
                        return this.nextCount != 0;
                    }

                    @Override
                    public Number next() {
                        this.setNext();
                        assert (this.nextCount != 0);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> normsIterable(final FieldInfo field, final NormsProducer normsProducer, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                NumericDocValues values;
                try {
                    values = normsProducer.getNorms(field);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public Number next() {
                        Number result;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values.docID()) {
                            try {
                                values.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values.docID()) {
                            try {
                                result = values.longValue();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        } else {
                            result = 0;
                        }
                        return result;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<BytesRef> binaryIterable(final FieldInfo field, final DocValuesProducer valuesProducer, final int maxDoc) {
        return new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                BinaryDocValues values;
                try {
                    values = valuesProducer.getBinary(field);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<BytesRef>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public BytesRef next() {
                        BytesRef result;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values.docID()) {
                            try {
                                values.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values.docID()) {
                            try {
                                result = values.binaryValue();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            result = null;
                        }
                        return result;
                    }
                };
            }
        };
    }

    @Deprecated
    public static Iterable<Number> numericIterable(final FieldInfo field, final DocValuesProducer valuesProducer, final int maxDoc) {
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                NumericDocValues values;
                try {
                    values = valuesProducer.getNumeric(field);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                return new Iterator<Number>(){
                    private int docIDUpto = -1;

                    @Override
                    public boolean hasNext() {
                        return this.docIDUpto + 1 < maxDoc;
                    }

                    @Override
                    public Number next() {
                        Long result;
                        ++this.docIDUpto;
                        if (this.docIDUpto > values.docID()) {
                            try {
                                values.nextDoc();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        }
                        if (this.docIDUpto == values.docID()) {
                            try {
                                result = values.longValue();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                        } else {
                            result = null;
                        }
                        return result;
                    }
                };
            }
        };
    }
}

