/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.TypeCompilerFactoryImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class BaseTypeCompiler
implements TypeCompiler {
    private TypeId correspondingTypeId;

    BaseTypeCompiler() {
    }

    @Override
    public String getPrimitiveMethodName() {
        SanityManager.THROWASSERT((String)("getPrimitiveMethodName not applicable for " + this.getClass().toString()));
        return null;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        throw StandardException.newException((String)"42Y95", (Object[])new Object[]{operator, leftType.getTypeId().getSQLTypeName(), rightType.getTypeId().getSQLTypeName()});
    }

    @Override
    public void generateNull(MethodBuilder mb, int collationType) {
        int argCount;
        if (this.pushCollationForDataValue(collationType)) {
            mb.push(collationType);
            argCount = 2;
        } else {
            argCount = 1;
        }
        mb.callMethod((short)185, null, this.nullMethodName(), this.interfaceName(), argCount);
    }

    @Override
    public void generateDataValue(MethodBuilder mb, int collationType, LocalField field) {
        int argCount;
        String interfaceName = this.interfaceName();
        if (field == null) {
            mb.pushNull(interfaceName);
        } else {
            mb.getField(field);
        }
        if (this.pushCollationForDataValue(collationType)) {
            mb.push(collationType);
            argCount = 3;
        } else {
            argCount = 2;
        }
        mb.callMethod((short)185, null, this.dataValueMethodName(), interfaceName, argCount);
        if (field != null) {
            mb.putField(field);
        }
    }

    abstract String nullMethodName();

    String dataValueMethodName() {
        return "getDataValue";
    }

    boolean pushCollationForDataValue(int collationType) {
        return false;
    }

    protected boolean userTypeStorable(TypeId thisType, TypeId otherType, ClassFactory cf) {
        if (otherType.userType()) {
            return cf.getClassInspector().assignableTo(thisType.getCorrespondingJavaTypeName(), otherType.getCorrespondingJavaTypeName());
        }
        return false;
    }

    boolean numberConvertible(TypeId otherType, boolean forDataTypeFunction) {
        boolean retval;
        if (otherType.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (otherType.isLongConcatableTypeId()) {
            return false;
        }
        boolean bl = retval = otherType.isNumericTypeId() || otherType.userType();
        if (forDataTypeFunction) {
            retval = retval || otherType.isFixedStringTypeId() && this.getTypeId().isFloatingPointTypeId();
        }
        retval = retval || otherType.isFixedStringTypeId() && !this.getTypeId().isFloatingPointTypeId();
        return retval;
    }

    boolean numberStorable(TypeId thisType, TypeId otherType, ClassFactory cf) {
        if (otherType.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (otherType.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(thisType, otherType, cf);
    }

    protected TypeId getTypeId() {
        return this.correspondingTypeId;
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompilerFactoryImpl.staticGetTypeCompiler(typeId);
    }

    void setTypeId(TypeId typeId) {
        this.correspondingTypeId = typeId;
    }

    protected int getStoredFormatIdFromTypeId() {
        return this.getTypeId().getTypeFormatId();
    }
}

