/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.uaparser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DeviceParser {
    private final List<DevicePattern> patterns;

    public static DeviceParser fromList(List<Map<String, String>> configList) {
        ArrayList<DevicePattern> configPatterns = new ArrayList<DevicePattern>();
        for (Map<String, String> configMap : configList) {
            configPatterns.add(DeviceParser.patternFromMap(configMap));
        }
        return new DeviceParser(configPatterns);
    }

    private DeviceParser(List<DevicePattern> patterns) {
        this.patterns = patterns;
    }

    public String parse(String agentString) {
        DevicePattern p;
        if (agentString == null) {
            return null;
        }
        String device = null;
        Iterator<DevicePattern> iterator = this.patterns.iterator();
        while (iterator.hasNext() && (device = (p = iterator.next()).match(agentString)) == null) {
        }
        if (device == null) {
            device = "Other";
        }
        return device;
    }

    private static DevicePattern patternFromMap(Map<String, String> configMap) {
        String regex = configMap.get("regex");
        if (regex == null) {
            throw new IllegalArgumentException("Device is missing regex");
        }
        Pattern pattern = "i".equals(configMap.get("regex_flag")) ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        return new DevicePattern(pattern, configMap.get("device_replacement"));
    }

    private static final class DevicePattern {
        private static final Pattern SUBSTITUTIONS_PATTERN = Pattern.compile("\\$\\d");
        private final Matcher matcher;
        private final String deviceReplacement;

        DevicePattern(Pattern pattern, String deviceReplacement) {
            this.matcher = pattern.matcher("");
            this.deviceReplacement = deviceReplacement;
        }

        public synchronized String match(CharSequence agentString) {
            this.matcher.reset(agentString);
            if (!this.matcher.find()) {
                return null;
            }
            String device = null;
            if (this.deviceReplacement != null) {
                if (this.deviceReplacement.contains("$")) {
                    device = this.deviceReplacement;
                    for (String substitution : DevicePattern.getSubstitutions(this.deviceReplacement)) {
                        int i = Integer.parseInt(substitution.substring(1));
                        String replacement = this.matcher.groupCount() >= i && this.matcher.group(i) != null ? Matcher.quoteReplacement(this.matcher.group(i)) : "";
                        device = device.replaceFirst('\\' + substitution, replacement);
                    }
                    device = device.trim();
                } else {
                    device = this.deviceReplacement;
                }
            } else if (this.matcher.groupCount() >= 1) {
                device = this.matcher.group(1);
            }
            return device;
        }

        private static Iterable<String> getSubstitutions(String deviceReplacement) {
            Matcher matcher = SUBSTITUTIONS_PATTERN.matcher(deviceReplacement);
            ArrayList<String> substitutions = new ArrayList<String>();
            while (matcher.find()) {
                substitutions.add(matcher.group());
            }
            return substitutions;
        }
    }
}

