/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.IllegalConnectionStringFormatException;
import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.MessagingFactory;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConnectionStringBuilder {
    static final String END_POINT_FORMAT = "sb://%s.%s";
    static final String HOST_NAME_FORMAT = "sb://%s";
    static final String DEFAULT_DOMAIN_NAME = "servicebus.windows.net";
    static final String HOST_NAME_CONFIG_NAME = "Hostname";
    static final String ENDPOINT_CONFIG_NAME = "Endpoint";
    static final String ENTITY_PATH_CONFIG_NAME = "EntityPath";
    static final String OPERATION_TIMEOUT_CONFIG_NAME = "OperationTimeout";
    static final String KEY_VALUE_SEPARATOR = "=";
    static final String KEY_VALUE_PAIR_DELIMITER = ";";
    static final String SHARED_ACCESS_KEY_NANE_CONFIG_NAME = "SharedAccessKeyName";
    static final String SHARED_ACCESS_KEY_CONFIG_NAME = "SharedAccessKey";
    static final String SHARED_ACCESS_SIGNATURE_CONFIG_NAME = "SharedAccessSignature";
    static final String TRANSPORT_TYPE_CONFIG_NAME = "TransportType";
    static final String AUTHENTICATION_CONFIG_NAME = "Authentication";
    public static final String MANAGED_IDENTITY_AUTHENTICATION = "Managed Identity";
    private static final String ALL_KEY_ENUMERATE_REGEX = "(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignature|EntityPath|OperationTimeout|TransportType|Authentication)";
    private static final String KEYS_WITH_DELIMITERS_REGEX = ";(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignature|EntityPath|OperationTimeout|TransportType|Authentication)=";
    private URI endpoint;
    private String eventHubName;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String sharedAccessSignature;
    private Duration operationTimeout;
    private TransportType transportType;
    private String authentication;

    public ConnectionStringBuilder() {
    }

    public ConnectionStringBuilder(String connectionString) {
        this.parseConnectionString(connectionString);
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public ConnectionStringBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionStringBuilder setEndpoint(String namespaceName, String domainName) {
        try {
            this.endpoint = new URI(String.format(Locale.US, END_POINT_FORMAT, namespaceName, domainName));
        }
        catch (URISyntaxException exception) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid namespace name: %s", namespaceName), exception);
        }
        return this;
    }

    public ConnectionStringBuilder setNamespaceName(String namespaceName) {
        return this.setEndpoint(namespaceName, DEFAULT_DOMAIN_NAME);
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public ConnectionStringBuilder setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    public String getSasKey() {
        return this.sharedAccessKey;
    }

    public ConnectionStringBuilder setSasKey(String sasKey) {
        this.sharedAccessKey = sasKey;
        return this;
    }

    public String getSasKeyName() {
        return this.sharedAccessKeyName;
    }

    public ConnectionStringBuilder setSasKeyName(String sasKeyName) {
        this.sharedAccessKeyName = sasKeyName;
        return this;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public ConnectionStringBuilder setSharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
        return this;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout == null ? MessagingFactory.DefaultOperationTimeout : this.operationTimeout;
    }

    public ConnectionStringBuilder setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public TransportType getTransportType() {
        return this.transportType == null ? TransportType.AMQP : this.transportType;
    }

    public ConnectionStringBuilder setTransportType(TransportType transportType) {
        this.transportType = transportType;
        return this;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public ConnectionStringBuilder setAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    public String toString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        if (this.endpoint != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENDPOINT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.endpoint.toString(), KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.eventHubName)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", ENTITY_PATH_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.eventHubName, KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SHARED_ACCESS_KEY_NANE_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKeyName, KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SHARED_ACCESS_KEY_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessKey, KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessSignature)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SHARED_ACCESS_SIGNATURE_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.sharedAccessSignature, KEY_VALUE_PAIR_DELIMITER));
        }
        if (this.operationTimeout != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", OPERATION_TIMEOUT_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.operationTimeout.toString(), KEY_VALUE_PAIR_DELIMITER));
        }
        if (this.transportType != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", TRANSPORT_TYPE_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.transportType.toString(), KEY_VALUE_PAIR_DELIMITER));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.authentication)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", AUTHENTICATION_CONFIG_NAME, KEY_VALUE_SEPARATOR, this.authentication, KEY_VALUE_PAIR_DELIMITER));
        }
        connectionStringBuilder.deleteCharAt(connectionStringBuilder.length() - 1);
        return connectionStringBuilder.toString();
    }

    private void parseConnectionString(String connectionString) {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalConnectionStringFormatException("connectionString cannot be empty");
        }
        String connection = KEY_VALUE_PAIR_DELIMITER + connectionString;
        Pattern keyValuePattern = Pattern.compile(KEYS_WITH_DELIMITERS_REGEX, 2);
        String[] values = keyValuePattern.split(connection);
        Matcher keys = keyValuePattern.matcher(connection);
        if (values == null || values.length <= 1 || keys.groupCount() == 0) {
            throw new IllegalConnectionStringFormatException("Connection String cannot be parsed.");
        }
        if (!StringUtil.isNullOrWhiteSpace(values[0])) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Cannot parse part of ConnectionString: %s", values[0]));
        }
        int valueIndex = 0;
        while (keys.find()) {
            String key = keys.group();
            key = key.substring(1, key.length() - 1);
            if (values.length < ++valueIndex + 1) {
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Value for the connection string parameter name: %s, not found", key));
            }
            if (key.equalsIgnoreCase(ENDPOINT_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOST_NAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(values[valueIndex]);
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be in format scheme://fullyQualifiedServiceBusNamespaceEndpointName", ENDPOINT_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(HOST_NAME_CONFIG_NAME)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", ENDPOINT_CONFIG_NAME, HOST_NAME_CONFIG_NAME));
                }
                try {
                    this.endpoint = new URI(String.format(Locale.US, HOST_NAME_FORMAT, values[valueIndex]));
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be a fully quantified host name address", HOST_NAME_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_NANE_CONFIG_NAME)) {
                this.sharedAccessKeyName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_KEY_CONFIG_NAME)) {
                this.sharedAccessKey = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SHARED_ACCESS_SIGNATURE_CONFIG_NAME)) {
                this.sharedAccessSignature = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(ENTITY_PATH_CONFIG_NAME)) {
                this.eventHubName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(OPERATION_TIMEOUT_CONFIG_NAME)) {
                try {
                    this.operationTimeout = Duration.parse(values[valueIndex]);
                    continue;
                }
                catch (DateTimeParseException exception) {
                    throw new IllegalConnectionStringFormatException("Invalid value specified for property 'Duration' in the ConnectionString.", exception);
                }
            }
            if (key.equalsIgnoreCase(TRANSPORT_TYPE_CONFIG_NAME)) {
                try {
                    this.transportType = TransportType.fromString(values[valueIndex]);
                    continue;
                }
                catch (IllegalArgumentException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid value specified for property '%s' in the ConnectionString.", TRANSPORT_TYPE_CONFIG_NAME), exception);
                }
            }
            if (key.equalsIgnoreCase(AUTHENTICATION_CONFIG_NAME)) {
                this.authentication = values[valueIndex];
                continue;
            }
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
    }
}

