"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _data_provider = require("../utils/data_provider");
var _security_solution_context = require("../../../containers/security_solution_context");
var _field_value = require("../../indicators/utils/field_value");
var _unwrap_value = require("../../indicators/utils/unwrap_value");
var _indicator = require("../../../../common/types/indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook that gets an {@link Indicator}, retrieves the field (from the RawIndicatorFieldId.Name)
 * and value, then creates DataProviders used to do the Investigate in Timeline logic
 * (see /kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/use_investigate_in_timeline.ts)
 */
const useInvestigateInTimeline = ({
  indicator
}) => {
  const securitySolutionContext = (0, _react.useContext)(_security_solution_context.SecuritySolutionContext);
  const {
    key,
    value
  } = (0, _field_value.getIndicatorFieldAndValue)(indicator, _indicator.RawIndicatorFieldId.Name);
  const sourceEventField = _indicator.IndicatorFieldEventEnrichmentMap[key];
  if (!(0, _field_value.fieldAndValueValid)(key, value) || !sourceEventField) {
    return {};
  }
  const dataProviders = [...sourceEventField, key].map(e => (0, _data_provider.generateDataProvider)(e, value));
  const indicatorTimestamp = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.TimeStamp);
  const from = (0, _moment.default)(indicatorTimestamp).subtract(7, 'd').toISOString();
  const to = (0, _moment.default)(indicatorTimestamp).add(7, 'd').toISOString();
  if (!to || !from) {
    return {};
  }
  const investigateInTimelineFn = securitySolutionContext === null || securitySolutionContext === void 0 ? void 0 : securitySolutionContext.getUseInvestigateInTimeline({
    dataProviders,
    from,
    to
  });
  return {
    investigateInTimelineFn
  };
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;