"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsRouteWrapper = void 0;
var _with_apm_span = require("@kbn/apm-data-access-plugin/server/utils/with_apm_span");
var _common = require("@kbn/spaces-plugin/common");
var _lodash = require("lodash");
var _coreHttpServer = require("@kbn/core-http-server");
var _monitor_config_repository = require("./services/monitor_config_repository");
var _service_api_key = require("./saved_objects/service_api_key");
var _lib = require("./lib");
var _constants = require("../common/constants");
var _check_has_privilege = require("./synthetics_service/authentication/check_has_privilege");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsRouteWrapper = (syntheticsRoute, server, syntheticsMonitorClient) => {
  var _syntheticsRoute$opti, _syntheticsRoute$requ;
  return {
    ...syntheticsRoute,
    options: {
      ...((_syntheticsRoute$opti = syntheticsRoute.options) !== null && _syntheticsRoute$opti !== void 0 ? _syntheticsRoute$opti : {})
    },
    security: {
      authz: {
        requiredPrivileges: ['uptime-read', ...((_syntheticsRoute$requ = syntheticsRoute.requiredPrivileges) !== null && _syntheticsRoute$requ !== void 0 ? _syntheticsRoute$requ : []), ...(syntheticsRoute !== null && syntheticsRoute !== void 0 && syntheticsRoute.writeAccess ? ['uptime-write'] : [])]
      }
    },
    handler: async (context, request, response) => {
      return (0, _with_apm_span.withApmSpan)('synthetics_route_handler', async () => {
        var _server$spaces$spaces, _server$spaces;
        const {
          elasticsearch,
          savedObjects,
          uiSettings
        } = await context.core;
        const {
          client: esClient
        } = elasticsearch;
        const savedObjectsClient = savedObjects.getClient({
          includedHiddenTypes: [_service_api_key.syntheticsServiceApiKey.name]
        });

        // specifically needed for the synthetics service api key generation
        server.authSavedObjectsClient = savedObjectsClient;
        const syntheticsEsClient = new _lib.SyntheticsEsClient(savedObjectsClient, esClient.asCurrentUser, {
          request,
          uiSettings,
          isDev: Boolean(server.isDev) && !(0, _lib.isTestUser)(server),
          heartbeatIndices: _constants.SYNTHETICS_INDEX_PATTERN
        });
        server.syntheticsEsClient = syntheticsEsClient;
        const encryptedSavedObjectsClient = server.encryptedSavedObjects.getClient();
        const monitorConfigRepository = new _monitor_config_repository.MonitorConfigRepository(savedObjectsClient, encryptedSavedObjectsClient);
        const spaceId = (_server$spaces$spaces = (_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
        try {
          const res = await syntheticsRoute.handler({
            syntheticsEsClient,
            savedObjectsClient,
            context,
            request,
            response,
            server,
            spaceId,
            syntheticsMonitorClient,
            monitorConfigRepository
          });
          if ((0, _coreHttpServer.isKibanaResponse)(res)) {
            return res;
          }
          const inspectData = await syntheticsEsClient.getInspectData(syntheticsRoute.path);
          if (Array.isArray(res)) {
            if ((0, _lodash.isEmpty)(inspectData)) {
              return response.ok({
                body: res
              });
            } else {
              return response.ok({
                body: {
                  result: res,
                  ...inspectData
                }
              });
            }
          }
          return response.ok({
            body: {
              ...res,
              ...inspectData
            }
          });
        } catch (e) {
          if ((0, _coreHttpServer.isKibanaResponse)(e)) {
            return e;
          }
          if (e.statusCode === 403) {
            const privileges = await (0, _check_has_privilege.checkIndicesReadPrivileges)(syntheticsEsClient);
            if (!privileges.has_all_requested) {
              return response.forbidden({
                body: {
                  message: 'MissingIndicesPrivileges: You do not have permission to read from the synthetics-* indices. Please contact your administrator.'
                }
              });
            }
          } else if (e.statusCode >= 500) {
            server.logger.error(e);
          } else {
            server.logger.debug(e);
          }
          throw e;
        }
      });
    }
  };
};
exports.syntheticsRouteWrapper = syntheticsRouteWrapper;