"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsTriggerTaskRun = void 0;
var _configSchema = require("@kbn/config-schema");
var _sync_private_locations_monitors_task = require("../../tasks/sync_private_locations_monitors_task");
var _clean_up_task = require("../../synthetics_service/private_location/clean_up_task");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsTriggerTaskRun = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.TRIGGER_TASK_RUN,
  validate: {
    params: _configSchema.schema.object({
      taskType: _configSchema.schema.oneOf([_configSchema.schema.literal('syncPrivateLocationMonitors'), _configSchema.schema.literal('cleanUpPackagePolicyTask')])
    })
  },
  writeAccess: true,
  handler: async ({
    server,
    request
  }) => {
    const {
      taskType
    } = request.params;
    switch (taskType) {
      case 'syncPrivateLocationMonitors':
        await server.pluginsStart.taskManager.runSoon(_sync_private_locations_monitors_task.PRIVATE_LOCATIONS_SYNC_TASK_ID);
        break;
      case 'cleanUpPackagePolicyTask':
        await (0, _clean_up_task.scheduleCleanUpTask)(server);
        break;
      default:
        throw new Error(`Unknown task type: ${taskType}`);
    }
  }
});
exports.getSyntheticsTriggerTaskRun = getSyntheticsTriggerTaskRun;