"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanUsePublicLocations = exports.useCanReadSyntheticsIndex = exports.useCanEditSynthetics = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCanEditSynthetics = () => {
  var _useKibana$services, _useKibana$services$a;
  return !!((_useKibana$services = (0, _public.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && _useKibana$services$a.capabilities.uptime.save);
};
exports.useCanEditSynthetics = useCanEditSynthetics;
const useCanUsePublicLocations = monLocations => {
  var _useKibana$services$a2, _useKibana$services2, _useKibana$services2$;
  const canUsePublicLocations = (_useKibana$services$a2 = (_useKibana$services2 = (0, _public.useKibana)().services) === null || _useKibana$services2 === void 0 ? void 0 : (_useKibana$services2$ = _useKibana$services2.application) === null || _useKibana$services2$ === void 0 ? void 0 : _useKibana$services2$.capabilities.uptime.elasticManagedLocationsEnabled) !== null && _useKibana$services$a2 !== void 0 ? _useKibana$services$a2 : true;
  const publicLocations = monLocations === null || monLocations === void 0 ? void 0 : monLocations.some(loc => loc.isServiceManaged);
  if (!publicLocations) {
    return true;
  }
  return !!canUsePublicLocations;
};
exports.useCanUsePublicLocations = useCanUsePublicLocations;
const useCanReadSyntheticsIndex = () => {
  const {
    services: {
      data: dataPublicPluginStart
    }
  } = (0, _public.useKibana)();
  const {
    data,
    loading,
    status
  } = (0, _public2.useFetcher)(() => {
    return new Promise(resolve => {
      dataPublicPluginStart.search.search({
        terminate_after: 1,
        params: {
          index: _constants.SYNTHETICS_INDEX_PATTERN,
          size: 0
        }
      }, {
        legacyHitsTotal: false
      }).subscribe({
        next: _ => {
          resolve({
            canRead: true,
            error: undefined
          });
        },
        error: error => {
          var _error$err, _error$err2;
          if (((_error$err = error.err) === null || _error$err === void 0 ? void 0 : _error$err.statusCode) >= 400 && ((_error$err2 = error.err) === null || _error$err2 === void 0 ? void 0 : _error$err2.statusCode) < 500) {
            resolve({
              canRead: false,
              error
            });
          } else {
            resolve({
              canRead: true,
              error
            });
          }
        }
      });
    });
  }, [dataPublicPluginStart.search]);
  return {
    canRead: data === null || data === void 0 ? void 0 : data.canRead,
    error: data === null || data === void 0 ? void 0 : data.error,
    loading,
    status
  };
};
exports.useCanReadSyntheticsIndex = useCanReadSyntheticsIndex;