"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowMode = TestNowMode;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_run_once_errors = require("./hooks/use_run_once_errors");
var _browser_test_results = require("./browser/browser_test_results");
var _simple_test_results = require("./simple/simple_test_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TestNowMode({
  testRun,
  onDone,
  isPushing,
  serviceError,
  errors
}) {
  var _testRun$monitor$loca;
  const {
    hasBlockingError,
    blockingErrorTitle,
    blockingErrorMessage,
    expectPings
  } = (0, _use_run_once_errors.useRunOnceErrors)({
    testRunId: testRun.id,
    serviceError,
    errors: errors !== null && errors !== void 0 ? errors : [],
    locations: (_testRun$monitor$loca = testRun.monitor.locations) !== null && _testRun$monitor$loca !== void 0 ? _testRun$monitor$loca : []
  });
  (0, _react.useEffect)(() => {
    if (!isPushing && (!testRun.id || hasBlockingError)) {
      onDone(testRun.id);
    }
    // we don't need onDone as a dependency since it's a function
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [testRun.id, hasBlockingError, isPushing]);
  const isBrowserMonitor = testRun.monitor.type === 'browser';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true
  }, hasBlockingError && !isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: blockingErrorTitle,
    color: "danger",
    iconType: "warning"
  }, blockingErrorMessage) || null, testRun && !hasBlockingError && !isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: testRun.id
  }, isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_browser_test_results.BrowserTestRunResult, {
    expectPings: expectPings,
    onDone: onDone,
    testRunId: testRun.id
  }) : /*#__PURE__*/_react.default.createElement(_simple_test_results.SimpleTestResults, {
    expectPings: expectPings,
    onDone: onDone,
    testRunId: testRun.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
}