"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastSuccessfulScreenshot = exports.IMAGE_UN_AVAILABLE = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _state = require("../../../state");
var _journey_step_screenshot_container = require("../../common/screenshot/journey_step_screenshot_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LastSuccessfulScreenshot = ({
  step,
  stepIndex: stepInd,
  size,
  borderRadius
}) => {
  var _data$synthetics, _data$synthetics$step, _data$synthetics2, _data$synthetics2$pay;
  const {
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    var _step$observer, _step$observer$geo;
    return (0, _state.fetchLastSuccessfulCheck)({
      timestamp: step['@timestamp'],
      monitorId: step.monitor.id,
      stepIndex: Number(stepIndex !== null && stepIndex !== void 0 ? stepIndex : stepInd),
      location: (_step$observer = step.observer) === null || _step$observer === void 0 ? void 0 : (_step$observer$geo = _step$observer.geo) === null || _step$observer$geo === void 0 ? void 0 : _step$observer$geo.name
    });
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Synthetics folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [step._id, step['@timestamp']]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: data === null || data === void 0 ? void 0 : data.monitor.check_group,
    initialStepNumber: data === null || data === void 0 ? void 0 : (_data$synthetics = data.synthetics) === null || _data$synthetics === void 0 ? void 0 : (_data$synthetics$step = _data$synthetics.step) === null || _data$synthetics$step === void 0 ? void 0 : _data$synthetics$step.index,
    stepStatus: data === null || data === void 0 ? void 0 : (_data$synthetics2 = data.synthetics) === null || _data$synthetics2 === void 0 ? void 0 : (_data$synthetics2$pay = _data$synthetics2.payload) === null || _data$synthetics2$pay === void 0 ? void 0 : _data$synthetics2$pay.status,
    allStepsLoaded: !loading,
    retryFetchOnRevisit: false,
    size: size,
    unavailableMessage: IMAGE_UN_AVAILABLE,
    borderRadius: borderRadius
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
};
exports.LastSuccessfulScreenshot = LastSuccessfulScreenshot;
const IMAGE_UN_AVAILABLE = exports.IMAGE_UN_AVAILABLE = _i18n.i18n.translate('xpack.synthetics.monitor.step.screenshot.unAvailable', {
  defaultMessage: 'Image unavailable'
});