"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuperSelect = exports.PolicyHostsField = exports.AGENT_POLICY_FIELD_NAME = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _contexts = require("../../../contexts");
var _agent_policy_callout = require("./agent_policy_callout");
var _agent_policies = require("../../../state/agent_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_POLICY_FIELD_NAME = exports.AGENT_POLICY_FIELD_NAME = 'agentPolicyId';
const PolicyHostsField = ({
  privateLocations,
  isDisabled
}) => {
  const {
    data
  } = (0, _reactRedux.useSelector)(_agent_policies.selectAgentPolicies);
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    control,
    formState: {
      isSubmitted
    },
    trigger,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    isTouched,
    error
  } = control.getFieldState(AGENT_POLICY_FIELD_NAME);
  const showFieldInvalid = (isSubmitted || isTouched) && !!error;
  const selectedPolicyId = getValues(AGENT_POLICY_FIELD_NAME);
  const selectedPolicy = data === null || data === void 0 ? void 0 : data.find(item => item.id === selectedPolicyId);
  const policyHostsOptions = data === null || data === void 0 ? void 0 : data.map(item => {
    const hasLocation = privateLocations.find(location => location.agentPolicyId === item.id);
    return {
      disabled: Boolean(hasLocation),
      value: item.id,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: item.status === 'active' ? 'success' : 'warning',
        css: {
          lineHeight: 'inherit'
        }
      }, item.name),
      'data-test-subj': item.name,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: hasLocation !== null && hasLocation !== void 0 && hasLocation.label ? _i18n.i18n.translate('xpack.synthetics.monitorManagement.anotherPrivateLocation', {
          defaultMessage: 'This agent policy is already attached to location: {locationName}.',
          values: {
            locationName: hasLocation === null || hasLocation === void 0 ? void 0 : hasLocation.label
          }
        }) : undefined
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: item.status === 'active' ? 'success' : 'warning',
        css: {
          lineHeight: 'inherit'
        }
      }, /*#__PURE__*/_react.default.createElement("strong", null, item.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        className: "eui-textNoWrap"
      }, /*#__PURE__*/_react.default.createElement("p", null, AGENTS_LABEL, " ", item.agents))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, item.description))))))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: POLICY_HOST_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsPolicyHostsFieldCreatePolicyButton",
      size: "xs",
      href: basePath + '/app/fleet/policies?create'
    }, _i18n.i18n.translate('xpack.synthetics.policyHostsField.createButtonEmptyLabel', {
      defaultMessage: 'Create policy'
    })),
    helpText: showFieldInvalid ? SELECT_POLICY_HOSTS_HELP_TEXT : undefined,
    isInvalid: showFieldInvalid,
    error: showFieldInvalid ? SELECT_POLICY_HOSTS : undefined
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: AGENT_POLICY_FIELD_NAME,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(SuperSelect, (0, _extends2.default)({
      disabled: isDisabled,
      fullWidth: true,
      "aria-label": SELECT_POLICY_HOSTS,
      placeholder: SELECT_POLICY_HOSTS,
      valueOfSelected: field.value,
      itemLayoutAlign: "top",
      popoverProps: {
        repositionOnScroll: true
      },
      hasDividers: true,
      isInvalid: showFieldInvalid,
      options: policyHostsOptions !== null && policyHostsOptions !== void 0 ? policyHostsOptions : []
    }, field, {
      onBlur: async () => {
        await trigger();
      }
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (selectedPolicy === null || selectedPolicy === void 0 ? void 0 : selectedPolicy.agents) === 0 && /*#__PURE__*/_react.default.createElement(_agent_policy_callout.AgentPolicyCallout, null));
};
exports.PolicyHostsField = PolicyHostsField;
const AGENTS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentsLabel', {
  defaultMessage: 'Agents: '
});
const SELECT_POLICY_HOSTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectPolicyHost', {
  defaultMessage: 'Select agent policy'
});
const SELECT_POLICY_HOSTS_HELP_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectPolicyHost.helpText', {
  defaultMessage: 'We recommend using a single Elastic agent per agent policy.'
});
const POLICY_HOST_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.policyHost', {
  defaultMessage: 'Agent policy'
});
const SuperSelect = exports.SuperSelect = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement("span", {
  ref: ref,
  tabIndex: -1
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, (0, _extends2.default)({
  "data-test-subj": "syntheticsAgentPolicySelect"
}, props))));