"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_view_buttons = require("./hooks/use_view_buttons");
var _labels = require("./labels");
var _use_overview_status = require("../../../hooks/use_overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleButtonsIcons = [{
  id: `cardView`,
  iconType: 'apps',
  label: _labels.CARD_VIEW_LABEL
}, {
  id: 'compactView',
  iconType: 'tableDensityCompact',
  label: _labels.COMPACT_VIEW_LABEL
}];
const ViewButtons = () => {
  const {
    status,
    loaded
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const {
    onChangeView,
    view
  } = (0, _use_view_buttons.useViewButtons)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    options: toggleButtonsIcons,
    idSelected: view,
    onChange: onChangeView,
    isIconOnly: true,
    isDisabled: !status || !loaded,
    legend: _labels.VIEW_LEGEND
  });
};
exports.ViewButtons = ViewButtons;