"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemExtra = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _formatting = require("../../../../../utils/formatting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricItemExtra = ({
  stats
}) => {
  const {
    avgDuration,
    minDuration,
    maxDuration
  } = stats;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "flexEnd"
    // empty title to prevent default title from showing
    ,
    title: "",
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, _i18n.i18n.translate('xpack.synthetics.overview.duration.label', {
    defaultMessage: 'Duration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, avgDuration && minDuration && maxDuration ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _i18n.i18n.translate('xpack.synthetics.overview.duration.description', {
      defaultMessage: 'Median duration of last 50 checks'
    }),
    content: _i18n.i18n.translate('xpack.synthetics.overview.duration.description.values', {
      defaultMessage: 'Avg: {avg}, Min: {min}, Max: {max}',
      values: {
        avg: (0, _formatting.formatDuration)(avgDuration, {
          noSpace: true
        }),
        min: (0, _formatting.formatDuration)(minDuration, {
          noSpace: true
        }),
        max: (0, _formatting.formatDuration)(maxDuration, {
          noSpace: true
        })
      }
    }),
    position: "top"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _i18n.i18n.translate('xpack.synthetics.overview.metricsTooltip.noMetrics.title', {
      defaultMessage: 'Metric data is not available'
    }),
    content: _i18n.i18n.translate('xpack.synthetics.overview.metricsTooltip.noMetrics.content', {
      defaultMessage: 'No metric data available for this monitor'
    })
  })));
};
exports.MetricItemExtra = MetricItemExtra;