"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPLOAD_SPEED_ERROR = exports.UPLOAD_LABEL = exports.ThrottlingUploadField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _throttling_exceeded_callout = require("./throttling_exceeded_callout");
var _optional_label = require("../optional_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThrottlingUploadField = ({
  readOnly,
  onFieldBlur,
  throttling,
  validate,
  handleInputChange,
  throttlingValue
}) => {
  var _validate$ConfigKey$T;
  const maxUpload = Number(_runtime_types.DEFAULT_BANDWIDTH_LIMIT[_runtime_types.BandwidthLimitKey.UPLOAD]);
  const exceedsUploadLimits = Number(throttlingValue.upload) > maxUpload;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: UPLOAD_LABEL,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_label.OptionalLabel, null),
    isInvalid: (validate ? !!(validate !== null && validate !== void 0 && (_validate$ConfigKey$T = validate[_runtime_types.ConfigKey.THROTTLING_CONFIG]) !== null && _validate$ConfigKey$T !== void 0 && _validate$ConfigKey$T.call(validate, throttling)) : false) || exceedsUploadLimits,
    error: exceedsUploadLimits ? /*#__PURE__*/_react.default.createElement(_throttling_exceeded_callout.ThrottlingExceededMessage, {
      throttlingField: "upload",
      limit: maxUpload
    }) : UPLOAD_SPEED_ERROR
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 0,
    step: 0.001,
    value: throttlingValue.upload,
    onChange: event => handleInputChange(event.target.value),
    onBlur: () => onFieldBlur === null || onFieldBlur === void 0 ? void 0 : onFieldBlur('upload'),
    "data-test-subj": "syntheticsBrowserUploadSpeed",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, "Mbps")),
    readOnly: readOnly
  }));
};
exports.ThrottlingUploadField = ThrottlingUploadField;
const UPLOAD_LABEL = exports.UPLOAD_LABEL = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.upload.label', {
  defaultMessage: 'Upload Speed'
});
const UPLOAD_SPEED_ERROR = exports.UPLOAD_SPEED_ERROR = _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.browserAdvancedSettings.throttling.upload.error', {
  defaultMessage: 'Upload speed must be greater than zero.'
});