"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusTranslations = exports.StatusRuleExpression = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _i18n = require("@kbn/i18n");
var _group_by_field = require("./common/group_by_field");
var _condition_window_value = require("./common/condition_window_value");
var _for_the_last_expression = require("./common/for_the_last_expression");
var _condition_locations_value = require("./common/condition_locations_value");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusRuleExpression = ({
  ruleParams,
  setRuleParams
}) => {
  var _ruleParams$condition, _condition$downThresh, _condition$locationsT, _ruleParams$condition5, _ruleParams$condition6;
  const condition = (_ruleParams$condition = ruleParams.condition) !== null && _ruleParams$condition !== void 0 ? _ruleParams$condition : _for_the_last_expression.DEFAULT_CONDITION;
  const downThreshold = (_condition$downThresh = condition === null || condition === void 0 ? void 0 : condition.downThreshold) !== null && _condition$downThresh !== void 0 ? _condition$downThresh : _for_the_last_expression.DEFAULT_CONDITION.downThreshold;
  const locationsThreshold = (_condition$locationsT = condition === null || condition === void 0 ? void 0 : condition.locationsThreshold) !== null && _condition$locationsT !== void 0 ? _condition$locationsT : _for_the_last_expression.DEFAULT_CONDITION.locationsThreshold;
  const onThresholdChange = (0, _react.useCallback)(value => {
    var _ruleParams$condition2;
    const prevCondition = (_ruleParams$condition2 = ruleParams.condition) !== null && _ruleParams$condition2 !== void 0 ? _ruleParams$condition2 : _for_the_last_expression.DEFAULT_CONDITION;
    setRuleParams('condition', {
      ...prevCondition,
      downThreshold: value
    });
  }, [ruleParams.condition, setRuleParams]);
  const onGroupByChange = (0, _react.useCallback)(groupByLocation => {
    var _ruleParams$condition3;
    setRuleParams('condition', {
      ...((_ruleParams$condition3 = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.condition) !== null && _ruleParams$condition3 !== void 0 ? _ruleParams$condition3 : _for_the_last_expression.DEFAULT_CONDITION),
      groupBy: groupByLocation ? 'locationId' : 'none'
    });
  }, [ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.condition, setRuleParams]);
  const onAlertOnNoDataChange = (0, _react.useCallback)(isChecked => {
    var _ruleParams$condition4;
    let newCondition = (_ruleParams$condition4 = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.condition) !== null && _ruleParams$condition4 !== void 0 ? _ruleParams$condition4 : _for_the_last_expression.DEFAULT_CONDITION;
    if (isChecked) {
      newCondition = {
        ...newCondition,
        alertOnNoData: true
      };
    } else if ('alertOnNoData' in newCondition) {
      const {
        alertOnNoData,
        ...rest
      } = newCondition;
      newCondition = rest;
    } else {
      throw new Error('Switch was unchecked but alertOnNoData was not set, this should not happen');
    }
    setRuleParams('condition', newCondition);
  }, [ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.condition, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "half",
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.rules.status.condition.title', {
    defaultMessage: 'Condition'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.synthetics.rule.condition.retests', {
      defaultMessage: 'Retests are included in the number of checks.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    "aria-label": StatusTranslations.criteriaAriaLabel,
    color: "success",
    description: StatusTranslations.criteriaDescription,
    value: StatusTranslations.criteriaValue
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
    value: downThreshold,
    valueLabel: _i18n.i18n.translate('xpack.synthetics.rules.status.valueLabel', {
      defaultMessage: '{threshold} times',
      values: {
        threshold: downThreshold
      }
    }),
    onChangeSelectedValue: val => {
      onThresholdChange(val);
    },
    description: StatusTranslations.isDownDescription,
    errors: []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_for_the_last_expression.ForTheLastExpression, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_condition_window_value.WindowValueExpression, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: StatusTranslations.fromLocationsDescription
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_condition_locations_value.LocationsValueExpression, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByExpression, {
    groupByLocation: ((_ruleParams$condition5 = ruleParams.condition) === null || _ruleParams$condition5 === void 0 ? void 0 : _ruleParams$condition5.groupBy) === 'locationId',
    onChange: onGroupByChange,
    locationsThreshold: locationsThreshold
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: ALERT_ON_NO_DATA_SWITCH_LABEL,
    checked: ((_ruleParams$condition6 = ruleParams.condition) === null || _ruleParams$condition6 === void 0 ? void 0 : _ruleParams$condition6.alertOnNoData) !== undefined,
    onChange: e => onAlertOnNoDataChange(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.StatusRuleExpression = StatusRuleExpression;
const StatusTranslations = exports.StatusTranslations = {
  criteriaAriaLabel: _i18n.i18n.translate('xpack.synthetics.rules.status.criteriaExpression.ariaLabel', {
    defaultMessage: 'An expression displaying the criteria for the monitors that are being watched by this alert'
  }),
  criteriaDescription: _i18n.i18n.translate('xpack.synthetics.alerts.tls.criteriaExpression.description', {
    defaultMessage: 'when'
  }),
  criteriaValue: _i18n.i18n.translate('xpack.synthetics.status.criteriaExpression.value', {
    defaultMessage: 'monitor'
  }),
  isDownDescription: _i18n.i18n.translate('xpack.synthetics.status.expirationExpression.description', {
    defaultMessage: 'is down '
  }),
  fromLocationsDescription: _i18n.i18n.translate('xpack.synthetics.status.locationsThreshold.description', {
    defaultMessage: 'from at least'
  })
};
const ALERT_ON_NO_DATA_SWITCH_LABEL = _i18n.i18n.translate('xpack.synthetics.statusRule.euiSwitch.alertOnNoData', {
  defaultMessage: "Alert me if there's no data"
});