"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDeleteModal = StreamDeleteModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDeleteModal({
  onClose,
  onDelete,
  onCancel,
  name,
  relatedStreams
}) {
  const {
    core: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const [isDeletingStream, setDeleteInProgress] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const handleDelete = async () => {
    try {
      setDeleteInProgress(true);
      await onDelete();
      setDeleteInProgress(false);
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleted', {
          defaultMessage: 'Stream deleted'
        })
      });
      onClose();
    } catch (error) {
      setDeleteInProgress(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.failedToDelete', {
          defaultMessage: 'Failed to delete stream {id}',
          values: {
            id: name
          }
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleteModalTitle', {
    defaultMessage: 'Are you sure you want to delete this data stream?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleteModalDescription', {
    defaultMessage: 'Deleting this stream will remove all of its children and the data will no longer be routed. All existing data will be removed as well.'
  })), relatedStreams.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleteModalStreams', {
    defaultMessage: 'The following streams will be deleted:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    maxWidth: false
  }, relatedStreams.map(stream => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: stream,
    target: "_blank",
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: stream,
        tab: 'route'
      }
    }),
    label: stream
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppStreamDetailRoutingCancelButton",
    onClick: onCancel
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.deleteModalCancel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppStreamDetailRoutingDeleteButton",
    color: "danger",
    fill: true,
    onClick: handleDelete,
    isLoading: isDeletingStream
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.delete', {
    defaultMessage: 'Delete'
  })))));
}