"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routingConverter = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createId = (0, _eui.htmlIdGenerator)();
const toUIDefinition = routingDefinition => ({
  id: createId(),
  ...routingDefinition
});
const toAPIDefinition = routingDefinitionWithAttributes => {
  return (0, _lodash.omit)(routingDefinitionWithAttributes, 'id');
};
const routingConverter = exports.routingConverter = {
  toAPIDefinition,
  toUIDefinition
};