"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackConnectorsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _connector_types = require("./connector_types");
var _experimental_features_service = require("./common/experimental_features_service");
var _experimental_features = require("../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StackConnectorsPublicPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.config = ctx.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []);
  }
  setup(core, {
    triggersActionsUi,
    actions
  }) {
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    (0, _connector_types.registerConnectorTypes)({
      connectorTypeRegistry: triggersActionsUi.actionTypeRegistry,
      services: {
        validateEmailAddresses: actions.validateEmailAddresses
      }
    });
  }
  start() {}
  stop() {}
}
exports.StackConnectorsPublicPlugin = StackConnectorsPublicPlugin;